/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.io.IOException;
import space.arim.omnibus.defaultimpl.events.BakedListenerGroup;
import space.arim.omnibus.defaultimpl.events.HierarchyScan;
import space.arim.omnibus.defaultimpl.events.Listener;

class EventClassDebug {
    private final Appendable output;
    private final boolean verbose;
    private final CharSequence indentPrefix;
    private boolean wroteAnything;

    EventClassDebug(Appendable output, boolean verbose, CharSequence indentPrefix) {
        this.output = output;
        this.verbose = verbose;
        this.indentPrefix = indentPrefix;
    }

    void debugEventClass(Class<?> eventClass, Listener<?>[] listeners, BakedListenerGroup listenerGroup) throws IOException {
        this.output.append('\n').append(this.indentPrefix).append("-- Event class ").append(eventClass.getName());
        this.appendHierarchy(eventClass);
        this.appendListeners(listeners);
        this.appendListenerGroup(listenerGroup);
        this.wroteAnything = true;
    }

    private void appendHierarchy(Class<?> eventClass) throws IOException {
        this.output.append('\n').append(this.indentPrefix).append("  Detected Class Hierarchy");
        if (this.verbose) {
            this.output.append(" (No particular order)");
        }
        for (Class<?> hierarchy : new HierarchyScan(eventClass).scan()) {
            this.output.append('\n').append(this.indentPrefix).append("    - ").append(hierarchy.getName());
        }
    }

    private void appendListeners(Listener<?>[] listeners) throws IOException {
        this.output.append('\n').append(this.indentPrefix);
        if (listeners == null) {
            this.output.append("  No directly specified listeners.");
            if (this.verbose) {
                this.output.append(" (This will necessarily be the case for encapsulated event implementations)");
            }
        } else {
            this.output.append("  Has directly specified listeners:");
            for (Listener<?> listener : listeners) {
                this.output.append('\n').append(this.indentPrefix).append("    - ").append(listener.toString());
            }
        }
    }

    private void appendListenerGroup(BakedListenerGroup listenerGroup) throws IOException {
        this.output.append('\n').append(this.indentPrefix);
        if (listenerGroup == null) {
            this.output.append("  No cached listeners.");
            if (this.verbose) {
                this.output.append(" (This will necessarily be the case for abstract event classes)");
            }
        } else {
            this.output.append("  Has cached listeners with the following information:");
            listenerGroup.debugTo(this.indentPrefix + "    ", this.output);
        }
    }

    boolean wroteAnything() {
        return this.wroteAnything;
    }
}

