/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CompletableFuture;
import space.arim.omnibus.defaultimpl.events.AsynchronousListener;
import space.arim.omnibus.defaultimpl.events.Listener;
import space.arim.omnibus.defaultimpl.events.SynchronousListener;
import space.arim.omnibus.events.AsyncEvent;
import space.arim.omnibus.events.EventFireController;

final class EventFire<E extends AsyncEvent> {
    private final Listener<E>[] toInvoke;
    private final E event;
    private final CompletableFuture<E> future;
    private int continuationIndex;
    private static final VarHandle CONTINUATION_INDEX;

    EventFire(Listener<E>[] toInvoke, E event, CompletableFuture<E> future) {
        this.toInvoke = toInvoke;
        this.event = event;
        this.future = future;
    }

    private static <E> void callSyncListener(SynchronousListener<E> invoke, E event) {
        Object eventConsumer = invoke.getEventConsumer();
        try {
            eventConsumer.accept(event);
        }
        catch (Exception ex) {
            EventFire.logException(eventConsumer, event, ex);
        }
    }

    static <E> void callSyncListeners(Listener<E>[] toInvoke, E event) {
        for (Listener<E> listener : toInvoke) {
            EventFire.callSyncListener((SynchronousListener)listener, event);
        }
    }

    void callAsyncListeners(int startIndex) {
        for (int currentIndex = startIndex; currentIndex < this.toInvoke.length; ++currentIndex) {
            Listener<E> listener = this.toInvoke[currentIndex];
            if (listener instanceof SynchronousListener) {
                EventFire.callSyncListener((SynchronousListener)listener, this.event);
                continue;
            }
            AsynchronousListener asyncListener = (AsynchronousListener)listener;
            Object asyncEventConsumer = asyncListener.getEventConsumer();
            AsyncFireController controller = new AsyncFireController(currentIndex);
            CONTINUATION_INDEX.setRelease(this, currentIndex);
            try {
                asyncEventConsumer.acceptAndContinue(this.event, controller);
                return;
            }
            catch (Exception ex) {
                EventFire.logException(asyncEventConsumer, this.event, ex);
                if (this.continuationIndex == currentIndex) continue;
                return;
            }
        }
        if (this.future != null) {
            this.future.complete(this.event);
        }
    }

    boolean changeIndex(int listenerIndex, int nextIndex) {
        int witnessValue = CONTINUATION_INDEX.compareAndExchangeAcquire(this, listenerIndex, nextIndex);
        return witnessValue == listenerIndex;
    }

    private static void logException(Object eventConsumer, Object event, Exception ex) {
        LoggerHolder.LOGGER.log(System.Logger.Level.WARNING, "Exception while calling event " + event + " for event consumer " + eventConsumer, (Throwable)ex);
    }

    static {
        try {
            CONTINUATION_INDEX = MethodHandles.lookup().findVarHandle(EventFire.class, "continuationIndex", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private class AsyncFireController
    implements EventFireController {
        private final int listenerIndex;

        AsyncFireController(int listenerIndex) {
            this.listenerIndex = listenerIndex;
        }

        @Override
        public void continueFire() {
            int nextIndex = this.listenerIndex + 1;
            if (!EventFire.this.changeIndex(this.listenerIndex, nextIndex)) {
                throw new IllegalStateException("Already fired");
            }
            EventFire.this.callAsyncListeners(nextIndex);
        }
    }

    private static final class LoggerHolder {
        static final System.Logger LOGGER = System.getLogger(EventFire.class.getName());

        private LoggerHolder() {
        }
    }
}

