/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

class HierarchyScan {
    private final Class<?> subject;

    HierarchyScan(Class<?> subject) {
        this.subject = subject;
    }

    Set<Class<?>> scan() {
        HashSet classes = new HashSet();
        Class<?> currentClass = this.subject;
        while (!currentClass.equals(Object.class)) {
            classes.add(currentClass);
            this.scanInterfaces(currentClass, classes::add);
            currentClass = currentClass.getSuperclass();
        }
        return Set.copyOf(classes);
    }

    private void scanInterfaces(Class<?> currentClass, Consumer<Class<?>> action) {
        for (Class<?> iface : currentClass.getInterfaces()) {
            action.accept(iface);
            this.scanInterfaces(iface, action);
        }
    }
}

