/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import space.arim.omnibus.events.RegisteredListener;

abstract class Listener<E>
implements RegisteredListener,
Comparable<Listener<?>> {
    private final Class<E> eventClass;
    private final byte priority;

    Listener(Class<E> eventClass, byte priority) {
        if (eventClass.isArray() || eventClass.isPrimitive() || eventClass.equals(Object.class)) {
            throw new IllegalArgumentException("Event class cannot be an array, a primitive, or Object");
        }
        this.eventClass = eventClass;
        this.priority = priority;
    }

    Class<E> getEventClass() {
        return this.eventClass;
    }

    byte priority() {
        return this.priority;
    }

    abstract Object getEventConsumer();

    @Override
    public int compareTo(Listener<?> other) {
        if (other == this) {
            return 0;
        }
        int priorityDiff = this.priority - other.priority;
        if (priorityDiff == 0) {
            int hashDiff = this.hashCode() - other.hashCode();
            if (hashDiff == 0) {
                return System.identityHashCode(this.getEventConsumer()) - System.identityHashCode(other.getEventConsumer());
            }
            return hashDiff;
        }
        return priorityDiff;
    }
}

