/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.registry;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import space.arim.omnibus.defaultimpl.registry.FifoEventQueue;
import space.arim.omnibus.defaultimpl.registry.RegistrationAddEventImpl;
import space.arim.omnibus.defaultimpl.registry.RegistrationRemoveEventImpl;
import space.arim.omnibus.defaultimpl.registry.ServiceChangeEventImpl;
import space.arim.omnibus.events.EventBus;
import space.arim.omnibus.registry.DuplicateRegistrationException;
import space.arim.omnibus.registry.Registration;
import space.arim.omnibus.registry.Registry;
import space.arim.omnibus.util.ArraysUtil;

public class DefaultRegistry
implements Registry {
    private final ConcurrentHashMap<Class<?>, Registration<?>[]> registry = new ConcurrentHashMap();
    private final EventBus eventBus;
    private final FifoEventQueue eventQueue = new FifoEventQueue();

    public DefaultRegistry(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    private void fireRegistryEvents() {
        this.eventQueue.fireEvents(this.eventBus);
    }

    private <T> Registration<T>[] addRegistration(Class<T> service, Registration<T> registration, T provider) {
        this.eventBus.fireAsyncEventWithoutFuture(new RegistrationAddEventImpl<T>(service, registration));
        Registration[] result = this.registry.compute(service, (s, registers) -> {
            if (registers == null) {
                this.eventQueue.offer(new ServiceChangeEventImpl(service, null, registration));
                return new Registration[]{registration};
            }
            for (Registration existing : registers) {
                if (existing.getProvider() != provider) continue;
                throw new DuplicateRegistrationException("Provider " + provider + " already registered for service " + service);
            }
            int insertionIndex = -(Arrays.binarySearch(registers, registration) + 1);
            if (((Registration[])registers).length == insertionIndex) {
                Registration previous = registers[((Registration[])registers).length - 1];
                this.eventQueue.offer(new ServiceChangeEventImpl(service, previous, registration));
            }
            return ArraysUtil.expandAndInsert(registers, registration, insertionIndex);
        });
        this.fireRegistryEvents();
        return result;
    }

    @Override
    public <T> Registration<T> register(Class<T> service, byte priority, T provider, String name) {
        service.cast(provider);
        Registration<T> registration = new Registration<T>(priority, provider, name);
        this.addRegistration(service, registration, provider);
        return registration;
    }

    @Override
    public <T> Registration<T> registerAndGet(Class<T> service, byte priority, T provider, String name) {
        service.cast(provider);
        Registration<T> registration = new Registration<T>(priority, provider, name);
        Registration<T>[] updated = this.addRegistration(service, registration, provider);
        return updated[updated.length - 1];
    }

    private <T> Registration<T>[] getRegistered(Class<T> service) {
        return this.registry.get(service);
    }

    @Override
    public <T> Optional<T> getProvider(Class<T> service) {
        Registration<T>[] registrations = this.getRegistered(service);
        if (registrations == null) {
            return Optional.empty();
        }
        return Optional.of(registrations[registrations.length - 1].getProvider());
    }

    @Override
    public <T> Optional<Registration<T>> getRegistration(Class<T> service) {
        Registration<T>[] registrations = this.getRegistered(service);
        if (registrations == null) {
            return Optional.empty();
        }
        return Optional.of(registrations[registrations.length - 1]);
    }

    @Override
    public <T> List<Registration<T>> getAllRegistrations(Class<T> service) {
        Registration<T>[] registrations = this.getRegistered(service);
        return registrations == null ? List.of() : List.of(registrations);
    }

    @Override
    public <T> boolean isProvidedFor(Class<T> service) {
        return this.registry.containsKey(service);
    }

    @Override
    public <T> Optional<Registration<T>> unregister(Class<T> service, Registration<T> registration) {
        Registration[] result = this.registry.computeIfPresent(service, (s, registers) -> {
            int locationIndex = Arrays.binarySearch(registers, registration);
            if (locationIndex < 0) {
                return registers;
            }
            this.eventQueue.offer(new RegistrationRemoveEventImpl(service, registration));
            if (((Registration[])registers).length == 1) {
                this.eventQueue.offer(new ServiceChangeEventImpl(service, registration, null));
                return null;
            }
            Registration[] updated = ArraysUtil.contractAndRemove(registers, locationIndex);
            if (locationIndex == ((Registration[])registers).length - 1) {
                this.eventQueue.offer(new ServiceChangeEventImpl(service, registration, updated[updated.length - 1]));
            }
            return updated;
        });
        this.fireRegistryEvents();
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result[result.length - 1]);
    }
}

