/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.registry;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import space.arim.omnibus.events.EventBus;
import space.arim.omnibus.registry.RegistryEvent;

class FifoEventQueue {
    private final Queue<RegistryEvent<?>> queue = new ConcurrentLinkedQueue();
    private volatile int queueState;
    private static final VarHandle QUEUE_STATE;
    private static final int UNHELD = 0;
    private static final int TRANSPOSING = 1;
    private static final int FIRING = 2;

    FifoEventQueue() {
    }

    void offer(RegistryEvent<?> event) {
        this.queue.offer(event);
    }

    void fireEvents(EventBus eventBus) {
        RegistryEvent<?> event;
        block5: while (true) {
            int witnessValue = QUEUE_STATE.compareAndExchange(this, 0, 1);
            switch (witnessValue) {
                case 0: {
                    break block5;
                }
                case 1: {
                    Thread.onSpinWait();
                    continue block5;
                }
                case 2: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown state " + witnessValue);
                }
            }
            break;
        }
        while ((event = this.queue.poll()) != null) {
            this.queueState = 2;
            eventBus.fireAsyncEventWithoutFuture(event);
            this.queueState = 1;
        }
        this.queueState = 0;
    }

    static {
        try {
            QUEUE_STATE = MethodHandles.lookup().findVarHandle(FifoEventQueue.class, "queueState", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

