/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.registry;

import java.util.Objects;

public final class Registration<T>
implements Comparable<Registration<T>> {
    private final byte priority;
    private final T provider;
    private final transient String name;

    public Registration(byte priority, T provider, String name) {
        this.priority = priority;
        this.provider = Objects.requireNonNull(provider, "provider");
        this.name = Objects.requireNonNull(name, "name");
    }

    public byte getPriority() {
        return this.priority;
    }

    public T getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Registration<T> other) {
        if (other == this) {
            return 0;
        }
        int priorityDiff = this.priority - other.priority;
        if (priorityDiff == 0) {
            if (this.provider == other.provider) {
                return 0;
            }
            int hashDiff = System.identityHashCode(this.provider) - System.identityHashCode(other.provider);
            if (hashDiff == 0) {
                return System.identityHashCode(this) - System.identityHashCode(other);
            }
            return hashDiff;
        }
        return priorityDiff;
    }

    public String toString() {
        return "Registration [priority=" + this.priority + ", provider=" + this.provider + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.priority;
        result = 31 * result + System.identityHashCode(this.provider);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)object;
        return this.priority == other.priority && this.provider == other.provider;
    }
}

