/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util;

import java.lang.reflect.Array;

public final class ArraysUtil {
    private ArraysUtil() {
    }

    public static <T> T[] expandAndInsert(T[] sourceArray, T element, int insertionIndex) {
        Object[] updated = (Object[])Array.newInstance(sourceArray.getClass().getComponentType(), sourceArray.length + 1);
        updated[insertionIndex] = element;
        System.arraycopy(sourceArray, 0, updated, 0, insertionIndex++);
        System.arraycopy(sourceArray, insertionIndex - 1, updated, insertionIndex, updated.length - insertionIndex);
        return updated;
    }

    public static <T> T[] contractAndRemove(T[] sourceArray, int removalIndex) {
        Object[] updated = (Object[])Array.newInstance(sourceArray.getClass().getComponentType(), sourceArray.length - 1);
        System.arraycopy(sourceArray, 0, updated, 0, removalIndex++);
        System.arraycopy(sourceArray, removalIndex, updated, removalIndex - 1, sourceArray.length - removalIndex);
        return updated;
    }
}

