/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class CompetitiveFuture<T>
extends CompletableFuture<T> {
    private final Executor defaultExecutor;

    public CompetitiveFuture(Executor defaultExecutor) {
        this.defaultExecutor = Objects.requireNonNull(defaultExecutor, "defaultExecutor");
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new CompetitiveFuture<T>(this.defaultExecutor);
    }

    @Override
    public Executor defaultExecutor() {
        return this.defaultExecutor;
    }

    public static CompetitiveFuture<Void> runAsync(Runnable command, Executor defaultExecutor) {
        Objects.requireNonNull(command, "Runnable must not be null");
        return CompetitiveFuture.supplyAsync(() -> {
            command.run();
            return null;
        }, defaultExecutor);
    }

    public static <T> CompetitiveFuture<T> supplyAsync(Supplier<T> supplier, Executor defaultExecutor) {
        return (CompetitiveFuture)new CompetitiveFuture<T>(defaultExecutor).completeAsync(supplier);
    }

    public static <T> CompetitiveFuture<T> completedFuture(T value, Executor defaultExecutor) {
        CompetitiveFuture<T> result = new CompetitiveFuture<T>(defaultExecutor);
        result.complete(value);
        return result;
    }

    public static <T> CompetitiveFuture<T> failedFuture(Throwable ex, Executor defaultExecutor) {
        CompetitiveFuture<T> result = new CompetitiveFuture<T>(defaultExecutor);
        result.completeExceptionally(ex);
        return result;
    }
}

