/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent.impl;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import space.arim.omnibus.util.concurrent.ScheduledTask;

abstract class AbstractScheduledTask
implements ScheduledTask {
    private static final AtomicLong SEQUENCER = new AtomicLong();
    private final long sequence = SEQUENCER.getAndIncrement();

    AbstractScheduledTask() {
    }

    abstract long getRunTime();

    private long getNanosDelay() {
        return this.getRunTime() - System.nanoTime();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getNanosDelay(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof AbstractScheduledTask) {
            AbstractScheduledTask otherTask = (AbstractScheduledTask)other;
            long diff = this.getRunTime() - otherTask.getRunTime();
            if (diff == 0L) {
                return Long.signum(this.sequence - otherTask.sequence);
            }
            return Long.signum(diff);
        }
        long diff = this.getNanosDelay() - other.getDelay(TimeUnit.NANOSECONDS);
        if (diff == 0L) {
            int hashDiff = this.hashCode() - other.hashCode();
            if (hashDiff == 0) {
                return this.getClass().hashCode() - other.getClass().hashCode();
            }
            return hashDiff;
        }
        return Long.signum(diff);
    }
}

