/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.util.concurrent.impl;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import space.arim.omnibus.util.concurrent.DelayCalculator;
import space.arim.omnibus.util.concurrent.EnhancedExecutor;
import space.arim.omnibus.util.concurrent.ScheduledTask;
import space.arim.omnibus.util.concurrent.impl.AlreadyCancelledTask;
import space.arim.omnibus.util.concurrent.impl.DelayedScheduledTaskImpl;
import space.arim.omnibus.util.concurrent.impl.RepeatingScheduledTaskImpl;
import space.arim.omnibus.util.concurrent.impl.RunnableScheduledTask;

public abstract class SimplifiedEnhancedExecutor
implements EnhancedExecutor {
    protected SimplifiedEnhancedExecutor() {
    }

    @Override
    public abstract void execute(Runnable var1);

    @Override
    public CompletableFuture<?> submit(Runnable command) {
        return CompletableFuture.runAsync(command, this);
    }

    @Override
    public <T> CompletableFuture<T> supply(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, this);
    }

    @Override
    public ScheduledTask scheduleOnce(Runnable command, Duration delay) {
        Objects.requireNonNull(command, "command");
        long nanosDelay = delay.toNanos();
        if (nanosDelay < 0L) {
            return new AlreadyCancelledTask(nanosDelay, false);
        }
        DelayedScheduledTaskImpl result = new DelayedScheduledTaskImpl(nanosDelay, command);
        this.publishTask(result, nanosDelay);
        return result;
    }

    @Override
    public ScheduledTask scheduleRepeating(Runnable command, Duration initialDelay, DelayCalculator delayCalculator) {
        Objects.requireNonNull(command, "command");
        return this.scheduleRepeating0(task -> command.run(), initialDelay, delayCalculator);
    }

    @Override
    public ScheduledTask scheduleRepeating(Consumer<? super ScheduledTask> command, Duration initialDelay, DelayCalculator delayCalculator) {
        Objects.requireNonNull(command, "command");
        return this.scheduleRepeating0(command, initialDelay, delayCalculator);
    }

    private ScheduledTask scheduleRepeating0(Consumer<? super ScheduledTask> command, Duration initialDelay, DelayCalculator delayCalculator) {
        Objects.requireNonNull(delayCalculator, "delayCalculator");
        long nanosDelay = initialDelay.toNanos();
        if (nanosDelay < 0L) {
            return new AlreadyCancelledTask(nanosDelay, true);
        }
        RepeatingScheduledTaskImpl result = new RepeatingScheduledTaskImpl(this, command, delayCalculator);
        result.update(nanosDelay, System.nanoTime());
        this.publishTask(result, nanosDelay);
        return result;
    }

    void publishTask(RunnableScheduledTask publishableTask, long nanosDelay) {
        if (nanosDelay == 0L) {
            this.execute(publishableTask);
        } else {
            CompletableFuture.delayedExecutor(nanosDelay, TimeUnit.NANOSECONDS, this).execute(publishableTask);
        }
    }
}

