/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.skills.damage;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.skills.SkillCaster;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageMetadata {
    private final SkillCaster damager;
    private final AbstractItemStack damagerItem;
    private double amount;
    private Map<String, Double> bonusDamage;
    private Map<String, Double> bonusDamageModifiers;
    @Deprecated
    private String element;
    private double multiplier = 1.0;
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private final Collection<String> tags = Sets.newHashSet();
    protected Boolean ignoresArmor;
    protected Boolean preventsImmunity;
    protected Boolean preventsKnockback;
    protected Boolean ignoreEnchantments;
    protected final EntityDamageEvent.DamageCause damageCause;

    public void putObject(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getValue(String key) {
        return this.data.get(key);
    }

    public Object getOrDefault(String key, Object def) {
        return this.data.getOrDefault(key, def);
    }

    public void putAll(Map<String, Object> data) {
        this.data.putAll(data);
    }

    public void putString(String key, String value) {
        this.data.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.data.put(key, value);
    }

    public void putTag(String key) {
        this.data.put(key, true);
        this.tags.add(key);
    }

    public void putFloat(String key, float value) {
        this.data.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.data.put(key, value);
    }

    public String getString(String key) {
        return this.data.get(key).toString();
    }

    public boolean getBoolean(String key) {
        Object object = this.getValue(key);
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        return false;
    }

    public float getFloat(String key) {
        Object object = this.getValue(key);
        if (object instanceof Float) {
            Float f = (Float)object;
            return f.floatValue();
        }
        throw new NumberFormatException(this.getString(key) + " is not a decimal value");
    }

    public double getDouble(String key) {
        Object object = this.getValue(key);
        if (object instanceof Double) {
            Double f = (Double)object;
            return f;
        }
        return this.getFloat(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DamageMetadata(damager=").append(this.getDamager().getName()).append(", amount=").append(this.getAmount()).append(", element=").append(this.getElement()).append(", ignoresArmor=").append(this.getIgnoresArmor()).append(", preventsImmunity=").append(this.getPreventsImmunity()).append(", preventsKnockback=").append(this.getPreventsKnockback()).append(", ignoreEnchantments=").append(this.getIgnoreEnchantments()).append(", damageCause=").append(this.getDamageCause());
        this.data.forEach((key, value) -> sb.append(", ").append((String)key).append("=").append(value));
        sb.append(")");
        return sb.toString();
    }

    public SkillCaster getDamager() {
        return this.damager;
    }

    public AbstractItemStack getDamagerItem() {
        return this.damagerItem;
    }

    public double getAmount() {
        return this.amount;
    }

    public Map<String, Double> getBonusDamage() {
        return this.bonusDamage;
    }

    public Map<String, Double> getBonusDamageModifiers() {
        return this.bonusDamageModifiers;
    }

    @Deprecated
    public String getElement() {
        return this.element;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public Boolean getIgnoresArmor() {
        return this.ignoresArmor;
    }

    public Boolean getPreventsImmunity() {
        return this.preventsImmunity;
    }

    public Boolean getPreventsKnockback() {
        return this.preventsKnockback;
    }

    public Boolean getIgnoreEnchantments() {
        return this.ignoreEnchantments;
    }

    public EntityDamageEvent.DamageCause getDamageCause() {
        return this.damageCause;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setBonusDamage(Map<String, Double> bonusDamage) {
        this.bonusDamage = bonusDamage;
    }

    public void setBonusDamageModifiers(Map<String, Double> bonusDamageModifiers) {
        this.bonusDamageModifiers = bonusDamageModifiers;
    }

    @Deprecated
    public void setElement(String element) {
        this.element = element;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setIgnoresArmor(Boolean ignoresArmor) {
        this.ignoresArmor = ignoresArmor;
    }

    public void setPreventsImmunity(Boolean preventsImmunity) {
        this.preventsImmunity = preventsImmunity;
    }

    public void setPreventsKnockback(Boolean preventsKnockback) {
        this.preventsKnockback = preventsKnockback;
    }

    public void setIgnoreEnchantments(Boolean ignoreEnchantments) {
        this.ignoreEnchantments = ignoreEnchantments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DamageMetadata)) {
            return false;
        }
        DamageMetadata other = (DamageMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
            return false;
        }
        Boolean this$ignoresArmor = this.getIgnoresArmor();
        Boolean other$ignoresArmor = other.getIgnoresArmor();
        if (this$ignoresArmor == null ? other$ignoresArmor != null : !((Object)this$ignoresArmor).equals(other$ignoresArmor)) {
            return false;
        }
        Boolean this$preventsImmunity = this.getPreventsImmunity();
        Boolean other$preventsImmunity = other.getPreventsImmunity();
        if (this$preventsImmunity == null ? other$preventsImmunity != null : !((Object)this$preventsImmunity).equals(other$preventsImmunity)) {
            return false;
        }
        Boolean this$preventsKnockback = this.getPreventsKnockback();
        Boolean other$preventsKnockback = other.getPreventsKnockback();
        if (this$preventsKnockback == null ? other$preventsKnockback != null : !((Object)this$preventsKnockback).equals(other$preventsKnockback)) {
            return false;
        }
        Boolean this$ignoreEnchantments = this.getIgnoreEnchantments();
        Boolean other$ignoreEnchantments = other.getIgnoreEnchantments();
        if (this$ignoreEnchantments == null ? other$ignoreEnchantments != null : !((Object)this$ignoreEnchantments).equals(other$ignoreEnchantments)) {
            return false;
        }
        SkillCaster this$damager = this.getDamager();
        SkillCaster other$damager = other.getDamager();
        if (this$damager == null ? other$damager != null : !this$damager.equals(other$damager)) {
            return false;
        }
        AbstractItemStack this$damagerItem = this.getDamagerItem();
        AbstractItemStack other$damagerItem = other.getDamagerItem();
        if (this$damagerItem == null ? other$damagerItem != null : !this$damagerItem.equals(other$damagerItem)) {
            return false;
        }
        Map<String, Double> this$bonusDamage = this.getBonusDamage();
        Map<String, Double> other$bonusDamage = other.getBonusDamage();
        if (this$bonusDamage == null ? other$bonusDamage != null : !((Object)this$bonusDamage).equals(other$bonusDamage)) {
            return false;
        }
        Map<String, Double> this$bonusDamageModifiers = this.getBonusDamageModifiers();
        Map<String, Double> other$bonusDamageModifiers = other.getBonusDamageModifiers();
        if (this$bonusDamageModifiers == null ? other$bonusDamageModifiers != null : !((Object)this$bonusDamageModifiers).equals(other$bonusDamageModifiers)) {
            return false;
        }
        String this$element = this.getElement();
        String other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Collection<String> this$tags = this.getTags();
        Collection<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        EntityDamageEvent.DamageCause this$damageCause = this.getDamageCause();
        EntityDamageEvent.DamageCause other$damageCause = other.getDamageCause();
        return !(this$damageCause == null ? other$damageCause != null : !this$damageCause.equals(other$damageCause));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DamageMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        Boolean $ignoresArmor = this.getIgnoresArmor();
        result = result * 59 + ($ignoresArmor == null ? 43 : ((Object)$ignoresArmor).hashCode());
        Boolean $preventsImmunity = this.getPreventsImmunity();
        result = result * 59 + ($preventsImmunity == null ? 43 : ((Object)$preventsImmunity).hashCode());
        Boolean $preventsKnockback = this.getPreventsKnockback();
        result = result * 59 + ($preventsKnockback == null ? 43 : ((Object)$preventsKnockback).hashCode());
        Boolean $ignoreEnchantments = this.getIgnoreEnchantments();
        result = result * 59 + ($ignoreEnchantments == null ? 43 : ((Object)$ignoreEnchantments).hashCode());
        SkillCaster $damager = this.getDamager();
        result = result * 59 + ($damager == null ? 43 : $damager.hashCode());
        AbstractItemStack $damagerItem = this.getDamagerItem();
        result = result * 59 + ($damagerItem == null ? 43 : $damagerItem.hashCode());
        Map<String, Double> $bonusDamage = this.getBonusDamage();
        result = result * 59 + ($bonusDamage == null ? 43 : ((Object)$bonusDamage).hashCode());
        Map<String, Double> $bonusDamageModifiers = this.getBonusDamageModifiers();
        result = result * 59 + ($bonusDamageModifiers == null ? 43 : ((Object)$bonusDamageModifiers).hashCode());
        String $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Collection<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        EntityDamageEvent.DamageCause $damageCause = this.getDamageCause();
        result = result * 59 + ($damageCause == null ? 43 : $damageCause.hashCode());
        return result;
    }

    public DamageMetadata(SkillCaster damager, AbstractItemStack damagerItem, double amount, Map<String, Double> bonusDamage, Map<String, Double> bonusDamageModifiers, String element, double multiplier, Boolean ignoresArmor, Boolean preventsImmunity, Boolean preventsKnockback, Boolean ignoreEnchantments, EntityDamageEvent.DamageCause damageCause) {
        this.damager = damager;
        this.damagerItem = damagerItem;
        this.amount = amount;
        this.bonusDamage = bonusDamage;
        this.bonusDamageModifiers = bonusDamageModifiers;
        this.element = element;
        this.multiplier = multiplier;
        this.ignoresArmor = ignoresArmor;
        this.preventsImmunity = preventsImmunity;
        this.preventsKnockback = preventsKnockback;
        this.ignoreEnchantments = ignoreEnchantments;
        this.damageCause = damageCause;
    }
}

