/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;
import org.joml.Vector3dc;

public abstract class PacketEntity<T extends IPacketEntityRenderer> {
    protected T renderer;
    protected boolean isDirty;
    protected AbstractWorld world;
    protected DataTracker<Vector3dc> location;
    protected DataTracker<Float> yaw;
    protected DataTracker<Float> pitch;
    protected DataTracker<AbstractVector> velocity;
    protected AbstractLocation previousLocation;
    protected DataTracker<Boolean> hasGravity;

    public PacketEntity(AbstractLocation location) {
        this.world = location.getWorld();
        this.location = DataTracker.of(location.toVector3d());
        this.yaw = DataTracker.of(Float.valueOf(location.getYaw()));
        this.pitch = DataTracker.of(Float.valueOf(location.getPitch()));
        this.velocity = DataTracker.of(new AbstractVector(0, 0, 0));
        this.previousLocation = new AbstractLocation();
        this.hasGravity = DataTracker.of(Boolean.TRUE);
    }

    protected void setRenderer(T renderer) {
        this.renderer = renderer;
    }

    public void update() {
        this.renderer.update();
    }

    public void destroy() {
        this.renderer.destroy();
    }

    public int getEntityId() {
        return this.renderer.getEntityId();
    }

    public DataTracker<Vector3dc> getLocation() {
        return this.location;
    }

    public void setPosition(AbstractLocation location) {
        this.world = location.getWorld();
        this.location.set(location.toVector3d());
        this.yaw.set(Float.valueOf(location.getYaw()));
        this.pitch.set(Float.valueOf(location.getPitch()));
        this.location.clearDirty();
        this.yaw.clearDirty();
        this.pitch.clearDirty();
    }

    public void teleport(AbstractLocation location) {
        this.world = location.getWorld();
        this.location.set(location.toVector3d());
        this.yaw.set(Float.valueOf(location.getYaw()));
        this.pitch.set(Float.valueOf(location.getPitch()));
        this.renderer.update();
    }

    public void setVelocity(AbstractVector velocity) {
        this.velocity.set(velocity.clone());
        this.renderer.update();
    }

    public void setHasGravity(Boolean bool) {
        this.hasGravity.set(bool);
        this.renderer.update();
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public T getRenderer() {
        return this.renderer;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public AbstractWorld getWorld() {
        return this.world;
    }

    public DataTracker<Float> getYaw() {
        return this.yaw;
    }

    public DataTracker<Float> getPitch() {
        return this.pitch;
    }

    public AbstractLocation getPreviousLocation() {
        return this.previousLocation;
    }

    public DataTracker<Boolean> getHasGravity() {
        return this.hasGravity;
    }
}

