/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

public abstract class PacketEntityRenderer<T extends PacketEntity<?>>
implements IPacketEntityRenderer<T> {
    protected final int entityId;
    protected final UUID uniqueId = UUID.randomUUID();
    protected final T wrapper;
    protected double cullingDistanceSq = 25000.0;
    protected Supplier<Collection<AbstractPlayer>> viewers = null;
    protected Object2ObjectOpenHashMap<AbstractPlayer, Boolean> trackedPlayers = new Object2ObjectOpenHashMap();
    protected Boolean renderDataPerPlayer = false;
    protected int mount = -1;
    private static final double POS_T = 8.0;
    private static final float ROT_MIN = 1.40625f;

    public PacketEntityRenderer(T wrapper) {
        this.entityId = MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getNextEntityId();
        this.wrapper = wrapper;
    }

    @Override
    public void spawn(AbstractPlayer target) {
        this.trackedPlayers.put((Object)target, (Object)false);
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawn() {
        this.spawn(() -> MythicBukkit.inst().getBootstrap().getOnlinePlayers());
    }

    @Override
    public void spawn(Supplier<Collection<AbstractPlayer>> playerSupplier) {
        this.viewers = playerSupplier;
        Collection<AbstractPlayer> players = playerSupplier.get();
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put((Object)player, (Object)false);
        }
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawn(AbstractWorld world) {
        this.spawn(() -> world.getPlayers());
    }

    @Override
    public void spawn(Collection<AbstractPlayer> players) {
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put((Object)player, (Object)false);
        }
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawnWithMount(AbstractPlayer target, PacketEntityRenderer mount) {
        ObjectArrayList packets = new ObjectArrayList();
        packets.addAll(mount.getSpawnPackets(target));
        packets.addAll(this.getSpawnPackets(target));
        packets.add(mount.createPassengerPacket(this.entityId));
        this.setMount(mount.getEntityId());
        this.sendPacket(target, (Collection<Object>)packets);
    }

    @Override
    public void spawnWithMount(Supplier<Collection<AbstractPlayer>> playerSupplier, PacketEntityRenderer mount) {
        this.viewers = playerSupplier;
        mount.setViewers(playerSupplier);
        Collection<AbstractPlayer> players = playerSupplier.get();
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put((Object)player, (Object)false);
            mount.getTrackedPlayers().put((Object)player, (Object)false);
        }
        this.updateRenderedPlayers(false);
        mount.updateRenderedPlayers(false);
        this.setMount(mount.getEntityId());
        for (Map.Entry tracked : this.trackedPlayers.entrySet()) {
            if (!((Boolean)tracked.getValue()).booleanValue()) continue;
            AbstractPlayer target = (AbstractPlayer)tracked.getKey();
            ObjectArrayList packets = new ObjectArrayList();
            packets.addAll(mount.getSpawnPackets(target));
            packets.addAll(this.getSpawnPackets(target));
            packets.add(mount.createPassengerPacket(this.entityId));
            this.sendPacket((AbstractPlayer)tracked.getKey(), (Collection<Object>)packets);
        }
    }

    @Override
    public void spawnWithMount(Collection<AbstractPlayer> players, PacketEntityRenderer mount) {
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put((Object)player, (Object)false);
            mount.getTrackedPlayers().put((Object)player, (Object)false);
        }
        this.updateRenderedPlayers(false);
        mount.updateRenderedPlayers(false);
        this.setMount(mount.getEntityId());
        for (Map.Entry tracked : this.trackedPlayers.entrySet()) {
            if (!((Boolean)tracked.getValue()).booleanValue()) continue;
            AbstractPlayer target = (AbstractPlayer)tracked.getKey();
            ObjectArrayList packets = new ObjectArrayList();
            packets.addAll(mount.getSpawnPackets(target));
            packets.addAll(this.getSpawnPackets(target));
            packets.add(mount.createPassengerPacket(this.entityId));
            this.sendPacket((AbstractPlayer)tracked.getKey(), (Collection<Object>)packets);
        }
    }

    @Override
    public void spawnWithMount(Supplier<Collection<AbstractPlayer>> playerSupplier, AbstractPlayer mount) {
        this.viewers = playerSupplier;
        Collection<AbstractPlayer> players = playerSupplier.get();
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put((Object)player, (Object)false);
        }
        this.updateRenderedPlayers(true);
        this.setMount(mount.getEntityId());
        for (Map.Entry tracked : this.trackedPlayers.entrySet()) {
            if (!((Boolean)tracked.getValue()).booleanValue()) continue;
            AbstractPlayer target = (AbstractPlayer)tracked.getKey();
            ObjectArrayList packets = new ObjectArrayList();
            packets.addAll(this.getSpawnPackets(target));
            packets.add(this.createMountPacket(this.entityId));
            this.sendPacket((AbstractPlayer)tracked.getKey(), (Collection<Object>)packets);
        }
    }

    @Override
    public void spawnWithMount(AbstractPlayer mount) {
        this.spawnWithMount(() -> mount.getWorld().getPlayers(), mount);
    }

    @Override
    public void setCullingDistance(int blocks) {
        this.cullingDistanceSq = Math.pow(blocks, 2.0);
    }

    @Override
    public void updateRenderedPlayers(boolean sendSpawnPacket) {
        if (this.viewers != null) {
            Collection<AbstractPlayer> viewerCollection = this.viewers.get();
            this.trackedPlayers.keySet().removeIf(player -> !viewerCollection.contains(player));
            for (AbstractPlayer player2 : viewerCollection) {
                this.trackedPlayers.putIfAbsent((Object)player2, (Object)false);
            }
        }
        Vector3dc location = ((PacketEntity)this.wrapper).getLocation().peek();
        this.trackedPlayers.replaceAll((player, value) -> {
            if (!((PacketEntity)this.wrapper).getWorld().equals(player.getWorld())) {
                return false;
            }
            double d = Math.pow(player.getLocation().getX() - location.x(), 2.0) + Math.pow(player.getLocation().getZ() - location.z(), 2.0);
            if (value.booleanValue()) {
                if (d > this.cullingDistanceSq) {
                    this.destroy((AbstractPlayer)player);
                    return false;
                }
            } else if (d <= this.cullingDistanceSq) {
                if (sendSpawnPacket) {
                    this.create((AbstractPlayer)player);
                }
                return true;
            }
            return value;
        });
    }

    public void sendPacket(Collection<AbstractPlayer> players, Collection<Object> packets) {
        if (packets.isEmpty()) {
            return;
        }
        ObjectArrayList validPackets = new ObjectArrayList();
        for (Object packet : packets) {
            if (packet == null) continue;
            validPackets.add(packet);
        }
        if (validPackets.isEmpty()) {
            return;
        }
        Object packet = validPackets.size() == 1 ? validPackets.get(0) : this.bundlePackets(validPackets);
        Schedulers.ensureAsync(() -> {
            for (AbstractPlayer player : players) {
                this.sendPacket(player, packet);
            }
        });
    }

    public void sendPacket(Object ... packets) {
        ObjectArrayList activePlayers = new ObjectArrayList();
        Object2ObjectMap.FastEntrySet entries = this.trackedPlayers.object2ObjectEntrySet();
        ObjectIterator it = entries.fastIterator();
        while (it.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)it.next();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            activePlayers.add((Object)((AbstractPlayer)entry.getKey()));
        }
        this.sendPacket((Collection<AbstractPlayer>)activePlayers, Arrays.asList(packets));
    }

    public void sendPacket(AbstractPlayer player, Collection<Object> packets) {
        this.sendPacket((Collection<AbstractPlayer>)ObjectArrayList.of((Object[])new AbstractPlayer[]{player}), packets);
    }

    public abstract void sendPacket(AbstractPlayer var1, @NotNull Object var2);

    @Override
    public void update() {
        Object packetTeleport = null;
        Object packetVelocity = null;
        if (this.mount < 0) {
            boolean minRotDelta;
            AbstractLocation base = ((PacketEntity)this.wrapper).previousLocation;
            Vector3dc pos = ((PacketEntity)this.wrapper).location.peek();
            double dx = pos.x() - base.getX();
            double dy = pos.y() - base.getY();
            double dz = pos.z() - base.getZ();
            Float yaw = ((PacketEntity)this.wrapper).yaw.peek();
            Float pitch = ((PacketEntity)this.wrapper).pitch.peek();
            boolean absPos = dx > 8.0 || dx < -8.0 || dy > 8.0 || dy < -8.0 || dz > 8.0 || dz < -8.0;
            boolean relPos = dx * dx + dy * dy + dz * dz >= MythicBukkit.inst().getConfiguration().getPacketMinimumPositionDelta();
            boolean bl = minRotDelta = Math.abs(yaw.floatValue() - base.getYaw()) >= 1.40625f || Math.abs(pitch.floatValue() - base.getPitch()) >= 1.40625f;
            if (!absPos) {
                if (minRotDelta && relPos) {
                    packetTeleport = this.createRelativePosRotPacket(dx, dy, dz, yaw.floatValue(), pitch.floatValue());
                } else if (relPos) {
                    packetTeleport = this.createRelativePosPacket(dx, dy, dz);
                } else if (minRotDelta) {
                    packetTeleport = this.createRelativeRotPacket(yaw.floatValue(), pitch.floatValue());
                }
            } else {
                packetTeleport = this.createTeleportPacket(pos.x(), pos.y(), pos.z(), yaw.floatValue(), pitch.floatValue());
            }
            if (((PacketEntity)this.wrapper).velocity.isDirty()) {
                AbstractVector velocity = ((PacketEntity)this.wrapper).velocity.get();
                packetVelocity = this.createVelocityPacket(velocity.getX(), velocity.getY(), velocity.getZ());
            }
            Vector3dc newPos = absPos || relPos ? ((PacketEntity)this.wrapper).location.get() : base.toVector3d();
            float newYaw = absPos || minRotDelta ? ((PacketEntity)this.wrapper).yaw.get().floatValue() : base.getYaw();
            float newPitch = absPos || minRotDelta ? ((PacketEntity)this.wrapper).pitch.get().floatValue() : base.getPitch();
            ((PacketEntity)this.wrapper).previousLocation = AbstractLocation.from(newPos, newYaw, newPitch);
        }
        if (this.renderDataPerPlayer.booleanValue()) {
            for (AbstractPlayer player : this.trackedPlayers.keySet()) {
                Object packetData = this.createDataPacket(player, false);
                if (packetTeleport != null) {
                    this.sendPacket(player, packetTeleport);
                }
                if (packetData != null) {
                    this.sendPacket(player, packetData);
                }
                if (packetVelocity == null) continue;
                this.sendPacket(player, packetVelocity);
            }
        } else {
            this.sendPacket(this.createDataPacket(false), packetTeleport, packetVelocity);
        }
    }

    private void create(AbstractPlayer target) {
        Collection<Object> packets = this.getSpawnPackets(target);
        if (this.mount > 0) {
            packets.add(this.createMountPacket(this.mount));
        }
        this.sendPacket(target, packets);
    }

    @Override
    public void destroy() {
        Object destroyPacket = this.createRemovePacket();
        ObjectSet set = this.trackedPlayers.keySet();
        for (AbstractPlayer player : set) {
            this.sendPacket(player, destroyPacket);
        }
        this.trackedPlayers.clear();
    }

    @Override
    public void destroy(AbstractPlayer player) {
        this.trackedPlayers.put((Object)player, (Object)false);
        Object destroyPacket = this.createRemovePacket();
        this.sendPacket(player, destroyPacket);
    }

    @Override
    public void mountEntity(AbstractEntity entity) {
        int id = entity.getBukkitEntity().getEntityId();
        Object packet = this.createMountPacket(id);
        if (packet != null) {
            this.mount = id;
            this.sendPacket(packet);
        }
    }

    @Override
    public void addPassenger(PacketEntityRenderer entity) {
        Object packet = this.createPassengerPacket(entity.getEntityId());
        if (packet != null) {
            entity.setMount(this.entityId);
            this.sendPacket(packet);
        }
    }

    protected short encodePos(double delta) {
        return (short)(delta * 4096.0);
    }

    protected byte encodeRot(float rot) {
        return (byte)(rot / 360.0f * 255.0f);
    }

    protected abstract Object bundlePackets(Object var1);

    protected abstract Collection<Object> getSpawnPackets(AbstractPlayer var1);

    protected abstract Object createSpawnPacket();

    protected abstract Object createDataPacket(boolean var1);

    protected Object createDataPacket(AbstractPlayer player, boolean force) {
        return this.createDataPacket(force);
    }

    protected abstract Object createRemovePacket();

    protected abstract Object createVelocityPacket(double var1, double var3, double var5);

    protected abstract Object createTeleportPacket(double var1, double var3, double var5, float var7, float var8);

    protected abstract Object createRelativePosPacket(double var1, double var3, double var5);

    protected abstract Object createRelativeRotPacket(float var1, float var2);

    protected abstract Object createRelativePosRotPacket(double var1, double var3, double var5, float var7, float var8);

    protected Object createMountPacket(int entityId) {
        return null;
    }

    protected Object createPassengerPacket(int entityId) {
        return null;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public T getWrapper() {
        return this.wrapper;
    }

    public void setViewers(Supplier<Collection<AbstractPlayer>> viewers) {
        this.viewers = viewers;
    }

    public Object2ObjectOpenHashMap<AbstractPlayer, Boolean> getTrackedPlayers() {
        return this.trackedPlayers;
    }

    public void setTrackedPlayers(Object2ObjectOpenHashMap<AbstractPlayer, Boolean> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
    }

    public Boolean getRenderDataPerPlayer() {
        return this.renderDataPerPlayer;
    }

    public void setRenderDataPerPlayer(Boolean renderDataPerPlayer) {
        this.renderDataPerPlayer = renderDataPerPlayer;
    }

    @Override
    public void setMount(int mount) {
        this.mount = mount;
    }
}

