/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractPotionEffect;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPlayer;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentPaperItemStack;
import io.lumine.mythic.bukkit.adapters.item.NbtBukkitItemStack;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.items.RandomTableItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class BukkitAdapter {
    public static AbstractEntity adapt(Entity entity) {
        if (entity == null) {
            return null;
        }
        return new BukkitEntity(entity);
    }

    public static Entity adapt(AbstractEntity entity) {
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public static AbstractPlayer adapt(Player player) {
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player);
    }

    public static ItemStack adapt(AbstractItemStack item) {
        if (item == null) {
            return null;
        }
        if (item instanceof BukkitItemStack) {
            BukkitItemStack bukkit = (BukkitItemStack)item;
            return bukkit.getItemStack();
        }
        if (item instanceof RandomTableItem) {
            RandomTableItem randomTableItem = (RandomTableItem)item;
            return BukkitAdapter.adapt(randomTableItem.getDropTable().generate().getSingleItem());
        }
        throw new IllegalArgumentException("cannot adapt unsupported platform item stack '" + item.getClass().getSimpleName() + "'.");
    }

    public static BukkitItemStack adapt(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
                return new ItemComponentPaperItemStack(item);
            }
            return new ItemComponentBukkitItemStack(item);
        }
        return new NbtBukkitItemStack(item);
    }

    public static BukkitItemStack adapt(Material material) {
        return BukkitAdapter.adapt(new ItemStack(material, 1));
    }

    public static BukkitBlock adapt(Block block) {
        return new BukkitBlock(block.getBlockData());
    }

    public static ItemFlag adapt(AbstractItemFlag flag) {
        return switch (flag) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractItemFlag.HIDE_ENCHANTS -> ItemFlag.HIDE_ENCHANTS;
            case AbstractItemFlag.HIDE_ATTRIBUTES -> ItemFlag.HIDE_ATTRIBUTES;
            case AbstractItemFlag.HIDE_UNBREAKABLE -> ItemFlag.HIDE_UNBREAKABLE;
            case AbstractItemFlag.HIDE_DESTROYS -> ItemFlag.HIDE_DESTROYS;
            case AbstractItemFlag.HIDE_PLACED_ON -> ItemFlag.HIDE_PLACED_ON;
            case AbstractItemFlag.HIDE_ADDITIONAL_TOOLTIP -> ItemFlag.HIDE_ADDITIONAL_TOOLTIP;
            case AbstractItemFlag.HIDE_DYE -> ItemFlag.HIDE_DYE;
            case AbstractItemFlag.HIDE_ARMOR_TRIM -> ItemFlag.HIDE_ARMOR_TRIM;
            case AbstractItemFlag.HIDE_STORED_ENCHANTS -> ItemFlag.HIDE_STORED_ENCHANTS;
            case AbstractItemFlag.HIDE_POTION_EFFECTS -> {
                if (ServerVersion.isBefore(MinecraftVersions.v1_20_5)) {
                    yield ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
                }
                MythicLogger.error("ItemFlag '" + String.valueOf((Object)flag) + "' does not exist in >=1.20.5.");
                yield ItemFlag.HIDE_ENCHANTS;
            }
        };
    }

    public static Player adapt(AbstractPlayer player) {
        if (player == null) {
            return null;
        }
        return (Player)player.getBukkitEntity();
    }

    public static AbstractWorld adapt(World world) {
        return new BukkitWorld(world);
    }

    public static World adapt(AbstractWorld world) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        if (world instanceof BukkitWorld) {
            BukkitWorld bukkitWorld = (BukkitWorld)world;
            return bukkitWorld.getBukkitWorld();
        }
        World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + String.valueOf(world));
    }

    public static AbstractLocation adapt(Location location) {
        if (location == null) {
            return null;
        }
        return new AbstractLocation(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location adapt(AbstractLocation location) {
        return new Location(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static AbstractVector adapt(Vector vector) {
        if (vector == null) {
            return null;
        }
        return new AbstractVector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector adapt(AbstractVector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static PotionEffect adapt(AbstractPotionEffect effect) {
        if (effect == null) {
            return null;
        }
        if (effect instanceof BukkitPotionEffect) {
            BukkitPotionEffect bukkitPotionEffect = (BukkitPotionEffect)effect;
            return bukkitPotionEffect.toBukkitEffect();
        }
        PotionEffectType type = PotionEffectType.getByName((String)effect.getEffectName());
        if (type == null) {
            return null;
        }
        return new PotionEffect(type, effect.getDuration(), effect.getLevel());
    }

    @Deprecated
    public static AbstractBiome adapt(Biome b) {
        String biome = b.getKey().getNamespace() + ":" + b.getKey().getKey();
        Optional<AbstractBiome> abs = MythicBukkit.inst().getVolatileCodeHandler().getWorldHandler().getBiome(biome);
        return abs.orElse(null);
    }

    public static EntitySnapshot getEntitySnapshot(MythicMob mm4) {
        String entityType = mm4.getEntityType().toString().toLowerCase();
        String snapshotString = "{id:\"minecraft:" + entityType + "\",BukkitValues:{\"mythicmobs:type\":\"" + mm4.getInternalName() + "\"}}";
        return Bukkit.getEntityFactory().createEntitySnapshot(snapshotString);
    }
}

