/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.bukkit.BukkitAdapter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class BukkitBlock
extends AbstractBlock {
    private final BlockData blockData;

    public static BukkitBlock get(AbstractLocation location) {
        return new BukkitBlock(BukkitAdapter.adapt(location).getBlock().getBlockData());
    }

    public BukkitBlock(String type) {
        this.blockData = Bukkit.createBlockData((String)type);
    }

    public BukkitBlock(Material material) {
        this.blockData = material.createBlockData();
    }

    public BukkitBlock(BlockData blockData) {
        this.blockData = blockData;
    }

    @Override
    public void set(AbstractLocation location) {
        this.set(location, true);
    }

    @Override
    public void set(AbstractLocation location, boolean physics) {
        Location l = BukkitAdapter.adapt(location);
        l.getBlock().setBlockData(this.blockData, physics);
    }

    @Override
    public boolean matches(AbstractLocation location) {
        BlockData tarBlock = BukkitAdapter.adapt(location).getBlock().getBlockData();
        return tarBlock.matches(this.blockData);
    }

    public boolean matches(Block block) {
        BlockData tarBlock = block.getBlockData();
        return tarBlock.matches(this.blockData);
    }

    @Override
    public boolean isAir() {
        return this.blockData.getMaterial().isAir();
    }

    @Override
    public PacketFallingBlock createFakeEntity(AbstractLocation location) {
        return new PacketFallingBlock(location, this.blockData);
    }

    public boolean equals(Object o) {
        if (o instanceof BukkitBlock) {
            BukkitBlock block = (BukkitBlock)o;
            return block.getBlockData().matches(this.blockData);
        }
        if (o instanceof String) {
            String string = (String)o;
            return this.blockData.getMaterial().toString().equalsIgnoreCase(string);
        }
        return false;
    }

    public int hashCode() {
        return this.blockData.hashCode();
    }

    @Override
    public BlockData getBlockData() {
        return this.blockData;
    }
}

