/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class BukkitItemMatcher
extends AbstractItemMatcher {
    private final Collection<Material> materials = Sets.newHashSet();
    private final Collection<AbstractItemStack> specificItems = Sets.newHashSet();
    private final Collection<Tag<Material>> tags = Sets.newHashSet();
    private boolean strict = false;

    public BukkitItemMatcher(MythicLineConfig config, String conditionVar) {
        this.strict = config.getBoolean(new String[]{"strict", "exact", "e"}, false);
        MythicBukkit.inst().getClock().queuePostReload(() -> {
            List<String> list = config.getStringList(new String[]{"types", "type", "t", "material", "mat", "m", "item", "i"}, "DIRT", conditionVar);
            for (String line : list) {
                this.parse(line);
            }
        });
    }

    public BukkitItemMatcher(String filter, boolean strict) {
        String[] split;
        for (String line : split = filter.split(",")) {
            this.parse(line);
        }
    }

    public BukkitItemMatcher(Collection<String> filter, boolean strict) {
        for (String line : filter) {
            this.parse(line);
        }
    }

    private void parse(String filter) {
        Material material;
        if (((String)filter).startsWith("#")) {
            NamespacedKey tagKey;
            Tag tag;
            if (!((String)(filter = ((String)filter).substring(1))).contains(":")) {
                filter = "minecraft:" + (String)filter;
            }
            if ((tag = Bukkit.getTag((String)"items", (NamespacedKey)(tagKey = NamespacedKey.fromString((String)filter)), Material.class)) == null) {
                MythicLogger.error("[ItemType] ItemTag '#" + String.valueOf(tagKey) + "' does not exist");
                return;
            }
            this.tags.add((Tag<Material>)tag);
            return;
        }
        if (((String)filter).contains("*")) {
            String regex = "^" + Pattern.quote((String)filter).replace("\\*", ".*").toUpperCase() + "$";
            Pattern pattern = Pattern.compile(regex);
            for (Material material2 : Material.values()) {
                String materialName;
                if (!material2.isItem() || !pattern.matcher(materialName = material2.toString().toUpperCase()).matches()) continue;
                this.materials.add(material2);
            }
        }
        if ((material = Material.getMaterial((String)((String)filter).toUpperCase())) != null) {
            this.materials.add(material);
            return;
        }
        AbstractItemStack item = MythicBukkit.inst().getBootstrap().createItem((String)filter);
        if (item != null) {
            this.specificItems.add(item);
        }
    }

    @Override
    public boolean matches(AbstractItemStack stack) {
        if (!(stack instanceof BukkitItemStack)) {
            return false;
        }
        BukkitItemStack bukkitItemStack = (BukkitItemStack)stack;
        if (!(this.materials.isEmpty() || this.strict && bukkitItemStack.getMythicItemType().isPresent() || !this.materials.contains(bukkitItemStack.getItemStack().getType()))) {
            return true;
        }
        if (!this.specificItems.isEmpty() && this.specificItems.contains(bukkitItemStack)) {
            return true;
        }
        if (!this.tags.isEmpty()) {
            Material material = bukkitItemStack.getItemStack().getType();
            for (Tag<Material> tag : this.tags) {
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        BukkitItemStack bukkitItemStack;
        Material material = stack.getType();
        if (!this.materials.isEmpty() && this.materials.contains(material)) {
            return true;
        }
        if (!this.tags.isEmpty()) {
            for (Tag<Material> tag : this.tags) {
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return !this.specificItems.isEmpty() && this.specificItems.contains(bukkitItemStack = BukkitAdapter.adapt(stack));
    }

    @Override
    public boolean matches(SkillMetadata skillMetadata) {
        Optional<Object> maybeItem = skillMetadata.getMetadata("item");
        if (maybeItem.isPresent()) {
            ItemStack itemStack = (ItemStack)maybeItem.get();
            BukkitItemStack aItemStack = BukkitAdapter.adapt(itemStack);
            return this.matches(aItemStack);
        }
        if (skillMetadata.getVariables().has("equip-item")) {
            ItemStack itemStack = (ItemStack)skillMetadata.getVariables().get("equip-item").get();
            BukkitItemStack aItemStack = BukkitAdapter.adapt(itemStack);
            return this.matches(aItemStack);
        }
        return false;
    }

    @Override
    public boolean matches(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        if (!(bukkitEntity instanceof Item)) {
            return false;
        }
        Item item = (Item)bukkitEntity;
        ItemStack itemStack = item.getItemStack();
        return this.matches(BukkitAdapter.adapt(itemStack));
    }

    public Collection<Material> getMaterials() {
        return this.materials;
    }

    public Collection<AbstractItemStack> getSpecificItems() {
        return this.specificItems;
    }

    public Collection<Tag<Material>> getTags() {
        return this.tags;
    }
}

