/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitTriggerMetadata;
import io.lumine.mythic.bukkit.entities.BukkitCreeper;
import io.lumine.mythic.bukkit.entities.BukkitTNT;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobInteractEvent;
import io.lumine.mythic.bukkit.events.MythicMobLootDropEvent;
import io.lumine.mythic.bukkit.listeners.triggers.DamageTriggerListeners;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.PluginModule;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.tracker.DamageRecord;
import io.lumine.mythic.core.mobs.tracker.DamageRecordManager;
import io.lumine.mythic.core.skills.EventExecutor;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.triggers.meta.SimpleEventSkillMetadata;
import io.lumine.mythic.core.utils.adventure.PaperHelper;
import io.papermc.paper.event.player.PlayerTradeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitSkillTriggers
extends PluginModule<MythicBukkit>
implements Listener {
    private final DamageTriggerListeners damageTriggerListeners;

    public BukkitSkillTriggers(MythicBukkit plugin) {
        super(plugin);
        this.damageTriggerListeners = new DamageTriggerListeners(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(EntityShootBowEvent.class).filter(event -> !event.isCancelled()).handler(this::onShootTrigger).bindWith(this);
        Events.subscribe(ProjectileLaunchEvent.class).filter(event -> !event.isCancelled()).filter(event -> event.getEntity().getShooter() != null).filter(event -> event.getEntity().getShooter() instanceof Entity).filter(event -> plugin.getMobManager().isActiveMob(((Entity)event.getEntity().getShooter()).getUniqueId())).handler(this::onShootProjectileTrigger).bindWith(this);
        Events.subscribe(EntityDeathEvent.class, EventPriority.HIGHEST).handler(this::onDeathTrigger).bindWith(this);
        Events.subscribe(CreeperPowerEvent.class).handler(this::onCreeperChargedTrigger).bindWith(this);
        Events.subscribe(EntityBreedEvent.class).handler(this::onEntityBreed).bindWith(this);
        Events.subscribe(EntityPortalEvent.class).handler(this::onWorldChange).bindWith(this);
        Events.subscribe(PlayerBucketEntityEvent.class).handler(this::onBucketEntityFill).bindWith(this);
        Events.subscribe(PlayerBucketFillEvent.class).handler(this::onBucketFill).bindWith(this);
        Events.subscribe(PlayerBucketEmptyEvent.class).handler(this::onBucketFill).bindWith(this);
        if (ServerVersion.isPaper()) {
            try {
                Events.subscribe(CreeperIgniteEvent.class).handler(this::onCreeperPrimeTrigger).bindWith(this);
                Events.subscribe(PlayerTradeEvent.class).handler(this::onMerchantTrade).bindWith(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void unload() {
    }

    protected EventExecutor eventBus() {
        return ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus();
    }

    void onBucketEntityFill(PlayerBucketEntityEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getEntity().getUniqueId()).ifPresent(mob -> {
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.BUCKET, (SkillCaster)mob, mob.getEntity(), mob.getLocation(), false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
                event.getPlayer().updateInventory();
            }
        });
    }

    void onBucketFill(PlayerBucketEvent event) {
        Location pos;
        Iterator entityIterator;
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getPlayer().getUniqueId()).ifPresent(mob -> {
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.BUCKET, (SkillCaster)mob, mob.getEntity(), mob.getLocation(), false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
                event.getPlayer().updateInventory();
            }
        });
        Entity targetEntity = event.getPlayer().getTargetEntity(5, true);
        if (targetEntity == null && (entityIterator = (pos = event.getBlock().getLocation()).getWorld().getNearbyEntities(pos, 3.0, 3.0, 3.0, entity -> entity instanceof Cow || entity instanceof MushroomCow).iterator()).hasNext()) {
            targetEntity = (Entity)entityIterator.next();
        }
        if (targetEntity != null) {
            ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(targetEntity.getUniqueId()).ifPresent(mob -> {
                AbstractPlayer player = BukkitAdapter.adapt(event.getPlayer());
                SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.BUCKET, (SkillCaster)mob, player, mob.getLocation(), false);
                TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                if (ts.getCancelled()) {
                    event.setCancelled(true);
                    event.getPlayer().updateInventory();
                }
            });
        }
    }

    void onWorldChange(EntityPortalEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getEntity().getUniqueId()).ifPresent(mob -> {
            if (event.getTo() == null) {
                return;
            }
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.CHANGE_WORLD, event, BukkitTriggerMetadata.entityPortal(), (SkillCaster)mob, mob.getEntity(), null, true);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        });
    }

    private void onMerchantTrade(PlayerTradeEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getVillager().getUniqueId()).ifPresent(am -> {
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.TRADE, (SkillCaster)am, BukkitAdapter.adapt(event.getPlayer()), null, false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        });
    }

    public void onEntityBreed(EntityBreedEvent event) {
        TriggeredSkill ts;
        SkillMetadata data;
        AbstractEntity mother = BukkitAdapter.adapt((Entity)event.getMother());
        AbstractEntity father = BukkitAdapter.adapt((Entity)event.getFather());
        AbstractEntity breeder = BukkitAdapter.adapt((Entity)event.getBreeder());
        if (((MythicBukkit)this.plugin).getMobManager().isActiveMob(mother)) {
            ActiveMob aMother = ((MythicBukkit)this.plugin).getMobManager().getMythicMobInstance(mother);
            if (aMother == null) {
                return;
            }
            data = this.eventBus().buildSkillMetadata(SkillTriggers.BREED, event, BukkitTriggerMetadata.entityBreed(), aMother, breeder, aMother.getLocation(), false);
            ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
        if (((MythicBukkit)this.plugin).getMobManager().isActiveMob(father)) {
            ActiveMob aFather = ((MythicBukkit)this.plugin).getMobManager().getMythicMobInstance(father);
            if (aFather == null) {
                return;
            }
            data = this.eventBus().buildSkillMetadata(SkillTriggers.BREED, event, BukkitTriggerMetadata.entityBreed(), aFather, breeder, aFather.getLocation(), false);
            ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public void onCreeperPrimeTrigger(CreeperIgniteEvent event) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreeperIgniteEvent fired", new Object[0]);
        Creeper l = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)l));
        SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.PRIME, am, am.getEntity(), null, true);
        TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
        if (ts.getCancelled()) {
            event.setCancelled(true);
        }
    }

    public void onCreeperChargedTrigger(CreeperPowerEvent event) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreeperPowerEvent fired", new Object[0]);
        Creeper l = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)l));
        SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.CREEPER_CHARGE, am, am.getEntity(), null, true);
        TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
        if (ts.getCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerInteractAtEntityEvent fired", new Object[0]);
        Entity clickedEntity = e.getRightClicked();
        if (!MythicBukkit.inst().getMobManager().isActiveMob(clickedEntity.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(clickedEntity.getUniqueId()).get();
        Player player = e.getPlayer();
        if (e.getHand() == EquipmentSlot.HAND) {
            MythicMobInteractEvent event = new MythicMobInteractEvent(e.getPlayer(), am);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                TriggeredSkill ts;
                Optional<Object> maybeHitboxData;
                SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.INTERACT, am, BukkitAdapter.adapt(player), null, true);
                if (((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine().isPresent() && clickedEntity.hasMetadata("hitbox") && (maybeHitboxData = BukkitAdapter.adapt(clickedEntity).getMetadata("hitbox")).isPresent()) {
                    String megHitbox = (String)maybeHitboxData.get();
                    data.getVariables().putString("hitbox", megHitbox);
                }
                if ((ts = this.eventBus().processTriggerMechanics(data)).getCancelled() || !am.getType().getIsInteractable()) {
                    e.setCancelled(true);
                    if (e.getRightClicked().getType().equals((Object)EntityType.VILLAGER)) {
                        Villager v = (Villager)e.getRightClicked();
                        if (player.getOpenInventory().getTopInventory().equals((Object)v.getInventory())) {
                            player.getOpenInventory().close();
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTameTrigger(EntityTameEvent event) {
        TameableProperty prop;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityTameEvent fired", new Object[0]);
        LivingEntity entity = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity.getUniqueId())) {
            return;
        }
        Player player = (Player)event.getOwner();
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)entity));
        if (am.getType().getMythicEntity() instanceof TameableEntityType && !(prop = ((TameableEntityType)((Object)am.getType().getMythicEntity())).getTameableProperty()).isTameable()) {
            event.setCancelled(true);
            Text.sendMessage((CommandSender)player, "<red>That mob cannot be tamed!");
            player.playSound(player.getLocation(), "entity.villager.no", 1.0f, 1.0f);
            return;
        }
        SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.TAME, am, BukkitAdapter.adapt(player), null, false);
        TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
        if (ts.getCancelled()) {
            event.setCancelled(true);
            return;
        }
        Schedulers.sync().runLater(() -> {
            am.getType().applyMobOptions(am, am.getLevel());
            am.getType().applyMobVolatileOptions(am);
        }, 5L);
    }

    public void onDeathTrigger(EntityDeathEvent event) {
        if (ServerVersion.isPaper() && event.isCancelled()) {
            return;
        }
        LivingEntity bukkitEntiity = event.getEntity();
        if (bukkitEntiity == null) {
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!                                                  !!!!!");
            MythicLogger.error("!!!!!     EntityDeathEvent.getEntity() is null????     !!!!!");
            MythicLogger.error("!!!!!     Executing rm -rf                             !!!!!");
            MythicLogger.error("!!!!!                                                  !!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            MythicLogger.error("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        boolean dropLoot = true;
        AbstractEntity killedEntity = BukkitAdapter.adapt((Entity)bukkitEntiity);
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(killedEntity);
        if (am != null) {
            MythicMob mm4 = am.getType();
            if (am.isDead()) {
                return;
            }
            LivingEntity killer = ((MythicBukkit)this.getPlugin()).getDropManager().getKiller(event);
            AbstractEntity aKiller = killer == null ? null : BukkitAdapter.adapt((Entity)killer);
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.DEATH, am, aKiller, null, false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled() && ServerVersion.isPaper()) {
                event.setReviveHealth(am.getType().getReviveHealth(am));
                event.setCancelled(true);
                return;
            }
            if (killer != null && !(killer instanceof Player) && ((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(killer.getUniqueId())) {
                ActiveMob amkiller = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    dropLoot = false;
                }
            }
            if (mm4.getPreventOtherDrops().booleanValue()) {
                event.getDrops().clear();
                event.setDroppedExp(0);
            }
            if (!am.getType().isDropsPerPlayer()) {
                DropMetadataImpl metadata = new DropMetadataImpl(am, aKiller);
                LootBag lootBag = mm4.getDropTable().generate(metadata);
                MythicMobLootDropEvent mythicLootEvent = new MythicMobLootDropEvent(am, killer, lootBag);
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobLootDropEvent for " + am.getType().getInternalName(), new Object[0]);
                Bukkit.getServer().getPluginManager().callEvent((Event)mythicLootEvent);
                if (dropLoot) {
                    ((MythicBukkit)this.getPlugin()).getDropManager().handleEntityLootDrops(event, lootBag, metadata, am);
                } else {
                    event.setDroppedExp(0);
                    event.getDrops().clear();
                }
            } else {
                DamageRecordManager recordManager = ((MythicBukkit)this.getPlugin()).getDamageRecordManager();
                DamageRecord record = recordManager.getRecord(am.getUniqueId());
                if (record != null) {
                    record.getDamagers().forEach(uuid -> {
                        Player damager = Bukkit.getPlayer((UUID)uuid);
                        if (damager != null) {
                            DropMetadataImpl metadata = new DropMetadataImpl(am, BukkitAdapter.adapt(damager));
                            LootBag lootBag = mm4.getDropTable().generate(metadata);
                            MythicMobLootDropEvent mythicLootEvent = new MythicMobLootDropEvent(am, (LivingEntity)damager, lootBag);
                            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobLootDropEvent for " + am.getType().getInternalName(), new Object[0]);
                            Bukkit.getServer().getPluginManager().callEvent((Event)mythicLootEvent);
                            ((MythicBukkit)this.getPlugin()).getDropManager().handleEntityLootDrops(event, lootBag, metadata, am);
                        }
                    });
                } else {
                    event.setDroppedExp(0);
                    event.getDrops().clear();
                }
            }
            MythicMobDeathEvent mythicDeathEvent = new MythicMobDeathEvent(am, killer, event.getDrops());
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobDeathEvent for " + am.getType().getInternalName(), new Object[0]);
            Bukkit.getServer().getPluginManager().callEvent((Event)mythicDeathEvent);
            am.setDead();
        } else {
            LivingEntity killerLE = ((MythicBukkit)this.getPlugin()).getDropManager().getKiller(event);
            if (killerLE != null && ((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(killerLE.getUniqueId())) {
                ActiveMob amkiller = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killerLE));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    event.setDroppedExp(0);
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Killed by entity with PreventKillDrops: true, cancelling drops!", new Object[0]);
                }
            }
        }
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeDeath(killedEntity);
            }
        });
    }

    public void onShootTrigger(EntityShootBowEvent event) {
        LivingEntity shooter = event.getEntity();
        if (shooter instanceof Player) {
            return;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().isIgnoredEntity(shooter.getUniqueId())) {
            return;
        }
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isMythicMob((Entity)shooter)) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)shooter);
        if (am != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob {0} shot a projectile!", am.getType().getInternalName());
            SkillMetadata metadata = this.eventBus().buildSkillMetadata(SkillTriggers.SHOOT, BukkitTriggerMetadata.entityShootBow(), am, am.getEntity(), am.getLocation(), false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(metadata);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public void onShootProjectileTrigger(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        EntityType projType = event.getEntityType();
        Entity shooter = (Entity)event.getEntity().getShooter();
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt(shooter));
        switch (shooter.getType()) {
            case BLAZE: {
                if (projType == EntityType.SMALL_FIREBALL) break;
                return;
            }
            case ENDER_DRAGON: {
                if (projType == EntityType.DRAGON_FIREBALL) break;
                return;
            }
            case GHAST: {
                if (projType == EntityType.FIREBALL) break;
                return;
            }
            case LLAMA: {
                if (projType == EntityType.LLAMA_SPIT) break;
                return;
            }
            case WITHER: {
                if (projType == EntityType.WITHER_SKULL) break;
                return;
            }
            case DROWNED: {
                if (projType == EntityType.TRIDENT) break;
                return;
            }
            case SNOW_GOLEM: {
                if (projType == EntityType.SNOWBALL) break;
                return;
            }
            default: {
                return;
            }
        }
        if (am != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob {0} shot a projectile!", am.getType().getInternalName());
            SimpleEventSkillMetadata<ProjectileLaunchEvent> triggerData = BukkitTriggerMetadata.projectileLaunch();
            SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.SHOOT, triggerData, am, am.getEntity(), am.getLocation(), false);
            TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        AbstractPlayer entity = BukkitAdapter.adapt(event.getPlayer());
        MythicBukkit.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeChangeWorld(entity);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerKillTrigger(PlayerDeathEvent event) {
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerDeathEvent fired", new Object[0]);
        Player p = event.getEntity();
        Player k = p.getKiller();
        AbstractPlayer player = BukkitAdapter.adapt(p);
        if (((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix() != null && event.getDeathMessage() != null) {
            if (ServerVersion.isPaper()) {
                event.deathMessage(PaperHelper.parse(((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix()).append(event.deathMessage()));
            } else {
                event.setDeathMessage(((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix() + event.getDeathMessage());
            }
        }
        if (k == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            k = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (k instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)k;
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
            if (am != null) {
                SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.KILLPLAYER, am, player, am.getLocation(), false);
                TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km4 = am.getType().getKillMessage();
                    event.setDeathMessage(km4.get((PlaceholderMeta)ts.getData(), player));
                }
            }
        } else if (k instanceof Projectile && (ps = ((Projectile)k).getShooter()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)ps;
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)shooter));
            if (am != null) {
                SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.KILLPLAYER, am, player, am.getLocation(), false);
                TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km5 = am.getType().getKillMessage();
                    event.setDeathMessage(km5.get((PlaceholderMeta)ts.getData(), player));
                }
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityExplodeEvent fired", new Object[0]);
        if (e.getEntity() == null) {
            return;
        }
        if (MythicBukkit.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e.getEntity()));
            if (am.getType().getMythicEntity() instanceof BukkitCreeper) {
                LivingEntity l = (LivingEntity)e.getEntity();
                if (((BukkitCreeper)am.getType().getMythicEntity()).preventSuicide()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MythicCreeper has preventSuicide == true, cloning creeper...", new Object[0]);
                    ActiveMob replacement = am.getType().spawn(am.getEntity().getLocation(), am.getLevel(), SpawnReason.OTHER);
                    LivingEntity ll = (LivingEntity)BukkitAdapter.adapt(replacement.getEntity());
                    ll.setMaxHealth(l.getMaxHealth());
                    ll.setHealth(l.getHealth());
                    if (l.getPassenger() != null) {
                        ll.setPassenger(l.getPassenger());
                    }
                    if (l.getVehicle() != null) {
                        l.getVehicle().setPassenger((Entity)ll);
                    }
                    Collection pe = l.getActivePotionEffects();
                    for (PotionEffect p : pe) {
                        ll.addPotionEffect(p);
                    }
                    ActiveMob am2 = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
                    if (am2 == null) {
                        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "! Something prevented Creeper from cloning! PreventSuicide failed :(", new Object[0]);
                        return;
                    }
                    am2.setStance(am.getStance());
                    am2.importPlayerKills(am.getPlayerKills());
                    am2.importThreatTable(am.getThreatTable());
                    SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.EXPLODE, am, null, null, false);
                    TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                } else {
                    SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.EXPLODE, am, null, null, false);
                    TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                }
            } else if (am.getType().getMythicEntity() instanceof BukkitTNT) {
                SkillMetadata data = this.eventBus().buildSkillMetadata(SkillTriggers.EXPLODE, am, null, null, false);
                TriggeredSkill ts = this.eventBus().processTriggerMechanics(data);
                if (ts.getCancelled()) {
                    e.setCancelled(true);
                }
                am.setDead();
                MythicBukkit.inst().getMobManager().unregisterActiveMob(am);
            }
        }
    }
}

