/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.SimpleEventSkillMetadata;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;

public final class BukkitTriggerMetadata {
    public static SimpleEventSkillMetadata<EntityShootBowEvent> entityShootBow() {
        return SkillTriggerMetadata.simpleEvent((event, data) -> {
            data.getVariables().putObject("shot-projectile", event.getEntity());
            data.getVariables().putFloat("bow-tension", event.getForce());
        });
    }

    public static SimpleEventSkillMetadata<EntityBreedEvent> entityBreed() {
        return SkillTriggerMetadata.simpleEvent((event, data) -> {
            data.getVariables().putObject("father", BukkitAdapter.adapt((Entity)event.getFather()));
            data.getVariables().putObject("mother", BukkitAdapter.adapt((Entity)event.getMother()));
            data.getVariables().putObject("child", BukkitAdapter.adapt((Entity)event.getEntity()));
        });
    }

    public static SimpleEventSkillMetadata<ProjectileLaunchEvent> projectileLaunch() {
        return SkillTriggerMetadata.simpleEvent((event, data) -> data.getVariables().putObject("shot-projectile", event.getEntity()));
    }

    public static SimpleEventSkillMetadata<EntityPortalEvent> entityPortal() {
        return SkillTriggerMetadata.simpleEvent((event, data) -> data.getVariables().putString("world", event.getTo().getWorld().getName()));
    }

    @Deprecated
    public static SkillMetadata apply(SkillMetadata meta, EntityDamageEvent event) {
        AbstractEntity damaged = BukkitAdapter.adapt(event.getEntity());
        Optional<Object> maybeData = damaged.getMetadata("skill-damage");
        meta.getVariables().putDouble("damage-amount", event.getFinalDamage());
        if (maybeData.isPresent()) {
            DamageMetadata data = (DamageMetadata)maybeData.get();
            meta.getVariables().putObject("damage-metadata", data);
            meta.getVariables().putString("damage-cause", "SKILL");
            meta.getVariables().putString("real-damage-cause", event.getCause().toString());
            meta.getVariables().putString("damage-type", data.getElement() == null ? "SKILL" : data.getElement());
        } else {
            meta.getVariables().putString("damage-cause", event.getCause().toString());
        }
        return meta;
    }

    @Deprecated
    public static SkillMetadata apply(SkillMetadata meta, EntityShootBowEvent event) {
        meta.getVariables().putObject("shot-projectile", event.getEntity());
        meta.getVariables().putFloat("bow-tension", event.getForce());
        return meta;
    }

    @Deprecated
    public static SkillMetadata apply(SkillMetadata meta, ProjectileLaunchEvent event) {
        meta.getVariables().putObject("shot-projectile", event.getEntity());
        return meta;
    }

    @Deprecated
    public static void apply(SkillMetadata meta, BlockBreakEvent event) {
    }

    @Deprecated
    public static void apply(SkillMetadata meta, BlockPlaceEvent event) {
    }
}

