/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GetBlockCoordinatesCommand
extends Command<MythicBukkit> {
    public GetBlockCoordinatesCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        AbstractPlayer player = BukkitAdapter.adapt(p);
        PlayerData profile = (PlayerData)((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(p);
        VariableRegistry variables = profile.getVariables();
        Variable lastCheckedLocation = variables.get("util-last-checked-coordinate");
        CommandHelper.sendHeader(sender);
        AbstractLocation location = player.getLocation();
        int bx = location.getBlockX();
        int by = location.getBlockY();
        int bz = location.getBlockZ();
        double cx = location.center().getX();
        double cy = location.center().getY();
        double cz = location.center().getZ();
        double ex = location.getX();
        double ey = location.getY();
        double ez = location.getZ();
        String bString = bx + "," + by + "," + bz;
        String cString = cx + "," + cy + "," + cz;
        String eString = ex + "," + ey + "," + ez;
        StringBuilder outputSelf = new StringBuilder().append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(bString).append(">Block</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(cString).append(">Center</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(eString).append(">Exact</click>").append("<gray>]").append("<gray> <gold>Coordinates<gray> >> ").append("<aqua>").append(bx).append(",").append(by).append(",").append(bz);
        CommandHelper.send(sender, outputSelf.toString());
        variables.putLocation("util-last-checked-coordinate", location);
        Location bukkitLocation = p.getTargetBlock((Set)null, 64).getLocation();
        if (bukkitLocation == null) {
            CommandHelper.sendError(sender, "You must target a valid block!");
            return true;
        }
        AbstractLocation location2 = BukkitAdapter.adapt(bukkitLocation);
        int bx2 = location2.getBlockX();
        int by2 = location2.getBlockY();
        int bz2 = location2.getBlockZ();
        double cx2 = location2.center().getX();
        double cy2 = location2.center().getY();
        double cz2 = location2.center().getZ();
        double ex2 = location2.getX();
        double ey2 = location2.getY();
        double ez2 = location2.getZ();
        String bString2 = bx2 + "," + by2 + "," + bz2;
        String cString2 = cx2 + "," + cy2 + "," + cz2;
        String eString2 = ex2 + "," + ey2 + "," + ez2;
        StringBuilder outputSelf2 = new StringBuilder().append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(bString2).append(">Block</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(cString2).append(">Center</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(eString2).append(">Exact</click>").append("<gray>]").append("<gray> <gold>Target <gray>>> <aqua>").append(bx2).append(",").append(by2).append(",").append(bz2);
        CommandHelper.send(sender, outputSelf2.toString());
        if (lastCheckedLocation != null) {
            location = (AbstractLocation)lastCheckedLocation.get();
            bx = location.getBlockX();
            by = location.getBlockY();
            bz = location.getBlockZ();
            cx = location.center().getX();
            cy = location.center().getY();
            cz = location.center().getZ();
            int ox = location.getBlockX() - player.getLocation().getBlockX();
            int oy = location.getBlockY() - player.getLocation().getBlockY();
            int oz = location.getBlockZ() - player.getLocation().getBlockZ();
            String bString3 = bx + "," + by + "," + bz;
            String cString3 = cx + "," + cy + "," + cz;
            String oString = "x=" + ox + ";y=" + oy + ";z=" + oz;
            StringBuilder outputSelf3 = new StringBuilder().append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(bString3).append(">Block</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(cString3).append(">Center</click>").append("<gray>]").append("<gray>[<yellow>").append("<click:copy_to_clipboard:").append(oString).append(">Offset</click>").append("<gray>]").append("<gray> <gold>Previous<gray> >> ").append("<aqua>").append(bx).append(",").append(by).append(",").append(bz);
            CommandHelper.send(sender, outputSelf3.toString());
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities.getblockcoordinates";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getcoordinates";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"gc", "getblockcoordinates", "getblockcoords", "gbc"};
    }
}

