/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitCat
extends BukkitEntityType
implements TameableEntityType {
    private final int height = 1;
    private final String headString = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjJjMWU4MWZmMDNlODJhM2U3MWUwY2Q1ZmJlYzYwN2UxMTM2MTA4OWFhNDdmMjkwZDQ2YzhhMmMwNzQ2MGQ5MiJ9fX0";
    private final ItemStack head = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem("PLAYER_HEAD").skullTexture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjJjMWU4MWZmMDNlODJhM2U3MWUwY2Q1ZmJlYzYwN2UxMTM2MTA4OWFhNDdmMjkwZDQ2YzhhMmMwNzQ2MGQ5MiJ9fX0"));
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private boolean tameable = false;
    private boolean tamed = false;
    private String variant;
    private DyeColor collarColor;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, (Set<Material>)Sets.immutableEnumSet((Enum)Material.COD, (Enum[])new Material[]{Material.SALMON}));
        this.tameable = mc.getBoolean("Options.Tameable", false);
        this.tamed = mc.getBoolean("Options.Tamed", false);
        this.variant = mc.getString(new String[]{"Options.Variant", "Options.CatType"}, null, new String[0]);
        String collarColor = mc.getString(new String[]{"Options.Color", "Options.CollarColor"}, null, new String[0]);
        if (collarColor != null) {
            try {
                this.collarColor = DyeColor.valueOf((String)collarColor.toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.CAT, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Cat e = (Cat)entity;
        this.ageableProperty.applyProperties(entity);
        e.setTamed(this.tamed);
        if (this.variant != null) {
            this.getPlugin().getVolatileCodeHandler().getCompatibilityHandler().setCatVariant(e, this.variant);
        }
        if (this.collarColor != null) {
            e.setCollarColor(this.collarColor);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Cat;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

