/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.ItemStack;

public class BukkitDonkey
extends BukkitEntityType
implements TameableEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private boolean horseChest;
    private boolean horseSaddled;
    private boolean horseTamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, (Set<Material>)Sets.immutableEnumSet((Enum)Material.APPLE, (Enum[])new Material[]{Material.GOLDEN_APPLE, Material.SUGAR, Material.WHEAT, Material.ENCHANTED_GOLDEN_APPLE, Material.GOLDEN_CARROT}));
        this.horseChest = mc.getBoolean("Options.HorseCarryingChest", false);
        this.horseChest = mc.getBoolean("Options.CarryingChest", this.horseChest);
        this.horseSaddled = mc.getBoolean("Options.HorseSaddled", false);
        this.horseSaddled = mc.getBoolean("Options.Saddled", this.horseSaddled);
        this.horseTamed = mc.getBoolean("Options.HorseTamed", false);
        this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.DONKEY, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Donkey e = (Donkey)entity;
        this.ageableProperty.applyProperties(entity);
        AbstractHorseInventory hi = e.getInventory();
        if (this.horseTamed) {
            e.setTamed(true);
        }
        if (this.horseSaddled) {
            hi.setSaddle(new ItemStack(Material.SADDLE, 1, 0));
        }
        if (this.horseChest) {
            e.setCarryingChest(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Donkey;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

