/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.volatilecode.VolatileAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;

public class BukkitHusk
extends BukkitEntityType {
    private static final int height = 2;
    private double reinforcementChance = -1.0;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Husk e = (Husk)this.spawnEntity(location, EntityType.HUSK, reason, prespawnFunc);
        e.setBaby(false);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Husk e = (Husk)entity;
        e.setBaby(false);
        e.getAttribute(VolatileAttribute.SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitHusk.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof Husk;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

