/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;

public class BukkitOcelot
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean tameable;
    private String ocelotType;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.ocelotType = mc.getString("Options.Ocelot", null);
        this.ocelotType = mc.getString("Options.OcelotType", this.ocelotType);
        this.tameable = mc.getBoolean("Options.Tameable", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.OCELOT, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Ocelot e = (Ocelot)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.ocelotType != null) {
            if (ServerVersion.isBefore(MinecraftVersions.v1_14)) {
                e.setCatType(Ocelot.Type.valueOf((String)this.ocelotType));
            } else {
                MythicLogger.errorGenericConfig("Ocelots no longer have cat types in versions >= 1.14");
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Ocelot;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }
}

