/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;
import org.bukkit.inventory.ItemStack;

public class BukkitPigZombie
extends BukkitEntityType {
    private final int height = 2;
    private final String headString = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzRlOWM2ZTk4NTgyZmZkOGZmOGZlYjMzMjJjZDE4NDljNDNmYjE2YjE1OGFiYjExY2E3YjQyZWRhNzc0M2ViIn19fQ";
    private final ItemStack head = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem("PLAYER_HEAD").skullTexture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzRlOWM2ZTk4NTgyZmZkOGZmOGZlYjMzMjJjZDE4NDljNDNmYjE2YjE1OGFiYjExY2E3YjQyZWRhNzc0M2ViIn19fQ"));
    private boolean angry = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.angry = mc.getBoolean("Options.Angry", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        PigZombie e = (PigZombie)this.spawnEntity(location, EntityType.ZOMBIFIED_PIGLIN, reason, prespawnFunc);
        e.setBaby(false);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        PigZombie e = (PigZombie)entity;
        e.setAngry(this.angry);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitPigZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (e instanceof PigZombie) {
            return !((PigZombie)e).isBaby();
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

