/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.MerchantProperty;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class BukkitVillager
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private MerchantProperty merchantProperty;
    private Villager.Type villagerType;
    private Villager.Profession villagerProfession;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.merchantProperty = new MerchantProperty(mc);
        String prof = mc.getNamespacedString("Options.Profession", "nitwit");
        this.villagerProfession = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(NamespacedKey.fromString((String)prof));
        if (prof != null && this.villagerProfession == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager profession configured");
        }
        String type = mc.getNamespacedString("Options.Type", "plains");
        this.villagerType = (Villager.Type)Registry.VILLAGER_TYPE.get(NamespacedKey.fromString((String)type));
        if (type != null && this.villagerType == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager type configured");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.VILLAGER, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Villager e = (Villager)entity;
        if (this.villagerType != null) {
            e.setVillagerType(this.villagerType);
        }
        if (this.villagerProfession != null) {
            e.setProfession(this.villagerProfession);
        } else if (this.merchantProperty.hasTrades()) {
            e.setProfession(Villager.Profession.NITWIT);
        }
        this.ageableProperty.applyProperties(entity);
        this.merchantProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Villager;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

