/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.client;

import io.lumine.mythic.bukkit.utils.lib.http.HeaderElement;
import io.lumine.mythic.bukkit.utils.lib.http.HttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ConnectionKeepAliveStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.message.BasicHeaderElementIterator;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

