/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.cookie;

import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.conn.util.PublicSuffixMatcher;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieOrigin;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieSpec;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieSpecProvider;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.MalformedCookieException;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.BasicDomainHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.BasicExpiresHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.BasicMaxAgeHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.BasicPathHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.BasicSecureHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.LaxExpiresHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.LaxMaxAgeHandler;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.PublicSuffixDomainFilter;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.RFC6265LaxSpec;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.RFC6265StrictSpec;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.HttpContext;

@Immutable
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

