/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.entity;

import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpMessage;
import io.lumine.mythic.bukkit.utils.lib.http.ProtocolException;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.entity.ContentLengthStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

