/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.XML;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractXMLBinding;
import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;

public class AbstractXMLasObjectBinding<T>
extends AbstractXMLBinding<T> {
    private final Converter<XML, T> converter;

    protected AbstractXMLasObjectBinding(Class<T> theType) {
        this.converter = new XMLasObjectConverter<T>(theType);
    }

    @Override
    public final Converter<XML, T> converter() {
        return this.converter;
    }

    private static final class XMLasObjectConverter<T>
    implements Converter<XML, T> {
        Class<T> type;
        XmlRootElement root;
        transient JAXBContext ctx;

        private XMLasObjectConverter(Class<T> type) {
            this.type = type;
            this.root = type.getAnnotation(XmlRootElement.class);
            this.ctx = this.initCtx();
        }

        private final JAXBContext initCtx() {
            try {
                return JAXBContext.newInstance(this.type);
            }
            catch (JAXBException e) {
                throw new DataBindingException(e);
            }
        }

        @Override
        public T from(XML t2) {
            if (t2 == null) {
                return null;
            }
            return JAXB.unmarshal(new StringReader("" + t2), this.type);
        }

        @Override
        public XML to(T u) {
            if (u == null) {
                return null;
            }
            try {
                StringWriter s2 = new StringWriter();
                Object o = u;
                if (this.root == null) {
                    o = new JAXBElement<T>(new QName(Introspector.decapitalize(this.type.getSimpleName())), this.type, u);
                }
                Marshaller m4 = this.ctx.createMarshaller();
                m4.setProperty("jaxb.fragment", true);
                m4.marshal(o, s2);
                return XML.xml(s2.toString());
            }
            catch (JAXBException e) {
                throw new DataBindingException(e);
            }
        }

        @Override
        public Class<XML> fromType() {
            return XML.class;
        }

        @Override
        public Class<T> toType() {
            return this.type;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.ctx = this.initCtx();
        }
    }
}

