/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Binding;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetResultSetContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetSQLInputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingRegisterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSQLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetSQLOutputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converters;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResourceManagingScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobBinding
implements Binding<String, String> {
    @Override
    public final Converter<String, String> converter() {
        return Converters.identity(String.class);
    }

    @Override
    public final void sql(BindingSQLContext<String> ctx) throws SQLException {
        ctx.render().visit(DSL.val((Object)ctx.value(), SQLDataType.CLOB));
    }

    @Override
    public final void register(BindingRegisterContext<String> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2005);
    }

    @Override
    public final void set(BindingSetStatementContext<String> ctx) throws SQLException {
        ctx.statement().setClob(ctx.index(), ClobBinding.newClob(ctx, ctx.value()));
    }

    @Override
    public final void set(BindingSetSQLOutputContext<String> ctx) throws SQLException {
        ctx.output().writeClob(ClobBinding.newClob(ctx, ctx.value()));
    }

    @Override
    public final void get(BindingGetResultSetContext<String> ctx) throws SQLException {
        Clob clob = ctx.resultSet().getClob(ctx.index());
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    @Override
    public final void get(BindingGetStatementContext<String> ctx) throws SQLException {
        Clob clob = ctx.statement().getClob(ctx.index());
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<String> ctx) throws SQLException {
        Clob clob = ctx.input().readClob();
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    static final Clob newClob(ResourceManagingScope scope, String string) throws SQLException {
        switch (scope.dialect()) {
            default: 
        }
        Clob clob = DefaultExecuteContext.localConnection().createClob();
        scope.autoFree(clob);
        clob.setString(1L, string);
        return clob;
    }
}

