/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.ExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.ExecuteListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.ExecuteListenerProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.InvocationOrder;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.SettingsTools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FetchServerOutputListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.LoggerListener;
import java.util.ArrayList;
import java.util.List;

final class ExecuteListeners
implements ExecuteListener {
    private static final ExecuteListener EMPTY_LISTENER = new DefaultExecuteListener();
    private static final JooqLogger LOGGER_LISTENER_LOGGER = JooqLogger.getLogger(LoggerListener.class);
    private final ExecuteListener[][] listeners;
    private boolean resultStart;
    private boolean fetchEnd;

    static ExecuteListener get(ExecuteContext ctx) {
        ExecuteListener[][] listeners = ExecuteListeners.listeners(ctx);
        if (listeners == null) {
            return EMPTY_LISTENER;
        }
        return new ExecuteListeners(listeners);
    }

    static ExecuteListener getAndStart(ExecuteContext ctx) {
        ExecuteListener result = ExecuteListeners.get(ctx);
        result.start(ctx);
        return result;
    }

    private static final ExecuteListener[][] listeners(ExecuteContext ctx) {
        ExecuteListener[] executeListenerArray;
        ExecuteListener[] executeListenerArray2;
        List<ExecuteListener> list = null;
        if (SettingsTools.getFetchServerOutputSize(0, ctx.settings()) > 0) {
            list = ExecuteListeners.init(list);
            list.add(new FetchServerOutputListener());
        }
        if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && LOGGER_LISTENER_LOGGER.isDebugEnabled()) {
            list = ExecuteListeners.init(list);
            list.add(new LoggerListener());
        }
        for (ExecuteListenerProvider provider : ctx.configuration().executeListenerProviders()) {
            if (provider == null) continue;
            list = ExecuteListeners.init(list);
            list.add(provider.provide());
        }
        if (list == null) {
            return null;
        }
        ExecuteListener[] def = list.toArray(Tools.EMPTY_EXECUTE_LISTENER);
        ExecuteListener[] rev = null;
        ExecuteListener[][] executeListenerArray3 = new ExecuteListener[2][];
        if (ctx.settings().getExecuteListenerStartInvocationOrder() != InvocationOrder.REVERSE) {
            executeListenerArray2 = def;
        } else {
            rev = Tools.reverse((ExecuteListener[])def.clone());
            executeListenerArray2 = executeListenerArray3[0] = rev;
        }
        if (ctx.settings().getExecuteListenerEndInvocationOrder() != InvocationOrder.REVERSE) {
            executeListenerArray = def;
        } else if (rev != null) {
            executeListenerArray = rev;
        } else {
            rev = Tools.reverse((ExecuteListener[])def.clone());
            executeListenerArray = rev;
        }
        executeListenerArray3[1] = executeListenerArray;
        return executeListenerArray3;
    }

    private static final List<ExecuteListener> init(List<ExecuteListener> result) {
        return result == null ? new ArrayList() : result;
    }

    private ExecuteListeners(ExecuteListener[][] listeners) {
        this.listeners = listeners;
    }

    @Override
    public final void start(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.start(ctx);
        }
    }

    @Override
    public final void renderStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.renderStart(ctx);
        }
    }

    @Override
    public final void renderEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.renderEnd(ctx);
        }
    }

    @Override
    public final void prepareStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.prepareStart(ctx);
        }
    }

    @Override
    public final void prepareEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.prepareEnd(ctx);
        }
    }

    @Override
    public final void bindStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.bindStart(ctx);
        }
    }

    @Override
    public final void bindEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.bindEnd(ctx);
        }
    }

    @Override
    public final void executeStart(ExecuteContext ctx) {
        if (ctx instanceof DefaultExecuteContext) {
            ((DefaultExecuteContext)ctx).incrementStatementExecutionCount();
        }
        for (ExecuteListener listener : this.listeners[0]) {
            listener.executeStart(ctx);
        }
    }

    @Override
    public final void executeEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.executeEnd(ctx);
        }
    }

    @Override
    public final void fetchStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.fetchStart(ctx);
        }
    }

    @Override
    public final void outStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.outStart(ctx);
        }
    }

    @Override
    public final void outEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.outEnd(ctx);
        }
    }

    @Override
    public final void resultStart(ExecuteContext ctx) {
        this.resultStart = true;
        for (ExecuteListener listener : this.listeners[0]) {
            listener.resultStart(ctx);
        }
        ++((DefaultExecuteContext)ctx).resultLevel;
    }

    @Override
    public final void recordStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.recordStart(ctx);
        }
        ++((DefaultExecuteContext)ctx).recordLevel;
    }

    @Override
    public final void recordEnd(ExecuteContext ctx) {
        --((DefaultExecuteContext)ctx).recordLevel;
        for (ExecuteListener listener : this.listeners[1]) {
            listener.recordEnd(ctx);
        }
    }

    @Override
    public final void resultEnd(ExecuteContext ctx) {
        --((DefaultExecuteContext)ctx).resultLevel;
        this.resultStart = false;
        for (ExecuteListener listener : this.listeners[1]) {
            listener.resultEnd(ctx);
        }
        if (this.fetchEnd) {
            this.fetchEnd(ctx);
        }
    }

    @Override
    public final void fetchEnd(ExecuteContext ctx) {
        if (this.resultStart) {
            this.fetchEnd = true;
        } else {
            for (ExecuteListener listener : this.listeners[1]) {
                listener.fetchEnd(ctx);
            }
        }
    }

    @Override
    public final void end(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.end(ctx);
        }
    }

    @Override
    public final void exception(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.exception(ctx);
        }
    }

    @Override
    public final void warning(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.warning(ctx);
        }
    }
}

