/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Internal;
import io.lumine.mythic.bukkit.utils.lib.jooq.Keyword;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record1;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.Sequence;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableLike;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.SQLDialectNotSupportedException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTypedNamed;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CommentImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

@Internal
public class SequenceImpl<T extends Number>
extends AbstractTypedNamed<T>
implements Sequence<T>,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.SEQUENCE, Clause.SEQUENCE_REFERENCE};
    private final boolean nameIsPlainSQL;
    private final Schema schema;
    private final Field<T> startWith;
    private final Field<T> incrementBy;
    private final Field<T> minvalue;
    private final Field<T> maxvalue;
    private final boolean cycle;
    private final Field<T> cache;
    private final SequenceFunction<T> currval;
    private final SequenceFunction<T> nextval;

    @Deprecated
    public SequenceImpl(String name, Schema schema, DataType<T> type) {
        this(name, schema, type, false);
    }

    SequenceImpl(String name, Schema schema, DataType<T> type, boolean nameIsPlainSQL) {
        this(DSL.name(name), schema, type, nameIsPlainSQL);
    }

    SequenceImpl(Name name, Schema schema, DataType<T> type, boolean nameIsPlainSQL) {
        this(name, schema, type, nameIsPlainSQL, null, null, null, null, false, null);
    }

    SequenceImpl(Name name, Schema schema, DataType<T> type, boolean nameIsPlainSQL, Field<T> startWith, Field<T> incrementBy, Field<T> minvalue, Field<T> maxvalue, boolean cycle, Field<T> cache) {
        super(SequenceImpl.qualify(schema, name), CommentImpl.NO_COMMENT, type);
        this.schema = schema;
        this.nameIsPlainSQL = nameIsPlainSQL;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.cycle = cycle;
        this.cache = cache;
        this.currval = new SequenceFunction(SequenceMethod.CURRVAL, this);
        this.nextval = new SequenceFunction(SequenceMethod.NEXTVAL, this);
    }

    @Override
    public final Catalog getCatalog() {
        return this.getSchema() == null ? null : this.getSchema().getCatalog();
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final Field<T> getStartWith() {
        return this.startWith;
    }

    @Override
    public final Field<T> getIncrementBy() {
        return this.incrementBy;
    }

    @Override
    public final Field<T> getMinvalue() {
        return this.minvalue;
    }

    @Override
    public final Field<T> getMaxvalue() {
        return this.maxvalue;
    }

    @Override
    public final boolean getCycle() {
        return this.cycle;
    }

    @Override
    public final Field<T> getCache() {
        return this.cache;
    }

    @Override
    public final Field<T> currval() {
        return this.currval;
    }

    @Override
    public final Field<T> nextval() {
        return this.nextval;
    }

    @Override
    public final Select<Record1<T>> nextvals(int size) {
        return DSL.select(this.nextval()).from((TableLike<?>)DSL.generateSeries(1, size).as(Names.N_GENERATE_SERIES));
    }

    @Override
    public final void accept(Context<?> ctx) {
        Schema mappedSchema = Tools.getMappedSchema(ctx, this.schema);
        if (mappedSchema != null && !"".equals(mappedSchema.getName()) && ctx.family() != SQLDialect.CUBRID) {
            ctx.visit(mappedSchema).sql('.');
        }
        if (this.nameIsPlainSQL) {
            ctx.sql(this.getName());
        } else {
            ctx.visit(this.getUnqualifiedName());
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Schema $schema() {
        return this.schema;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof SequenceImpl) {
            return this.getQualifiedName().equals(((SequenceImpl)that).getQualifiedName());
        }
        return super.equals(that);
    }

    private static class SequenceFunction<T extends Number>
    extends AbstractField<T>
    implements QOM.UNotYetImplemented {
        private final SequenceMethod method;
        private final SequenceImpl<T> sequence;

        SequenceFunction(SequenceMethod method, SequenceImpl<T> sequence) {
            super(method.name, sequence.getDataType());
            this.method = method;
            this.sequence = sequence;
        }

        @Override
        public final void accept(Context<?> ctx) {
            Configuration configuration = ctx.configuration();
            SQLDialect family = configuration.family();
            switch (family) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    ctx.visit(this.method.keyword).sql('(');
                    ctx.sql('\'').stringLiteral(true).visit(this.sequence).stringLiteral(false).sql('\'');
                    ctx.sql(')');
                    break;
                }
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case MARIADB: {
                    if (this.method == SequenceMethod.NEXTVAL) {
                        ctx.visit(Keywords.K_NEXT_VALUE_FOR).sql(' ').visit(this.sequence);
                        break;
                    }
                    if (family == SQLDialect.HSQLDB || family == SQLDialect.H2) {
                        ctx.visit(Keywords.K_CURRENT_VALUE_FOR).sql(' ').visit(this.sequence);
                        break;
                    }
                    if (family == SQLDialect.MARIADB) {
                        ctx.visit(Keywords.K_PREVIOUS_VALUE_FOR).sql(' ').visit(this.sequence);
                        break;
                    }
                    if (family == SQLDialect.FIREBIRD) {
                        ctx.visit(Names.N_GEN_ID).sql('(').visit(this.sequence).sql(", 0)");
                        break;
                    }
                    throw new SQLDialectNotSupportedException("The sequence's current value functionality is not supported for the " + family + " dialect.");
                }
                case CUBRID: {
                    ctx.visit(this.sequence).sql('.');
                    if (this.method == SequenceMethod.NEXTVAL) {
                        ctx.visit(DSL.keyword("next_value"));
                        break;
                    }
                    ctx.visit(DSL.keyword("current_value"));
                    break;
                }
                default: {
                    ctx.visit(this.sequence).sql('.').visit(this.method.keyword);
                }
            }
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof SequenceFunction) {
                return this.method == ((SequenceFunction)that).method && this.sequence.equals(((SequenceFunction)that).sequence);
            }
            return super.equals(that);
        }
    }

    private static enum SequenceMethod {
        CURRVAL(Keywords.K_CURRVAL, Names.N_CURRVAL),
        NEXTVAL(Keywords.K_NEXTVAL, Names.N_NEXTVAL);

        final Keyword keyword;
        final Name name;

        private SequenceMethod(Keyword keyword, Name name) {
            this.keyword = keyword;
            this.name = name;
        }
    }
}

