/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.network.messaging;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.annotation.NonnullByDefault;
import io.lumine.mythic.bukkit.utils.functions.TriConsumer;
import io.lumine.mythic.bukkit.utils.network.messaging.Channel;
import io.lumine.mythic.bukkit.utils.network.messaging.ChannelAgent;
import io.lumine.mythic.bukkit.utils.network.messaging.ChannelListener;
import io.lumine.mythic.bukkit.utils.network.messaging.MessagePacket;
import io.lumine.mythic.bukkit.utils.network.messaging.Messenger;
import io.lumine.mythic.bukkit.utils.network.messaging.codec.ByteArrayCodec;
import io.lumine.mythic.bukkit.utils.network.messaging.codec.Codec;
import io.lumine.mythic.bukkit.utils.network.messaging.codec.GsonCodec;
import io.lumine.mythic.bukkit.utils.network.messaging.codec.Message;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@NonnullByDefault
public class AbstractMessenger
implements Messenger {
    private final LoadingCache<Map.Entry<String, TypeToken<?>>, AbstractChannel<?>> channels = CacheBuilder.newBuilder().build(new ChannelLoader());
    private final String serverName;
    private final TriConsumer<String, String, byte[]> outgoingToMessages;
    private final BiConsumer<String, byte[]> outgoingMessages;
    private final Consumer<String> notifySub;
    private final Consumer<String> notifyUnsub;

    public AbstractMessenger(String serverName, BiConsumer<String, byte[]> outgoingMessages, TriConsumer<String, String, byte[]> outgoingToMessages, Consumer<String> notifySub, Consumer<String> notifyUnsub) {
        this.serverName = Objects.requireNonNull(serverName, "serverName");
        this.outgoingMessages = Objects.requireNonNull(outgoingMessages, "outgoingMessages");
        this.outgoingToMessages = Objects.requireNonNull(outgoingToMessages, "outgoingMessages");
        this.notifySub = Objects.requireNonNull(notifySub, "notifySub");
        this.notifyUnsub = Objects.requireNonNull(notifyUnsub, "notifyUnsub");
    }

    public void registerIncomingMessage(String channel, String sender, byte[] message) {
        for (Map.Entry c : this.channels.asMap().entrySet()) {
            if (!((String)((Map.Entry)c.getKey()).getKey()).equals(channel)) continue;
            ((AbstractChannel)c.getValue()).onIncomingMessage(message);
        }
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        Objects.requireNonNull(name, "name");
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Objects.requireNonNull(type, "type");
        return (Channel)this.channels.getUnchecked((Object)Maps.immutableEntry((Object)name, type));
    }

    private static <T> Codec<T> getCodec(TypeToken<T> type) {
        Class rawType = type.getRawType();
        do {
            Message message;
            if ((message = rawType.getAnnotation(Message.class)) == null) continue;
            Class<Codec<?>> codec = message.codec();
            try {
                return codec.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        } while ((rawType = rawType.getSuperclass()) != null);
        return new GsonCodec<T>(type);
    }

    public String getServerName() {
        return this.serverName;
    }

    private class ChannelLoader<T extends MessagePacket>
    extends CacheLoader<Map.Entry<String, TypeToken<T>>, Channel<T>> {
        private ChannelLoader() {
        }

        public Channel<T> load(Map.Entry<String, TypeToken<T>> spec) throws Exception {
            return new AbstractChannel<T>(AbstractMessenger.this, spec.getKey(), spec.getValue());
        }
    }

    private static class AbstractChannel<T extends MessagePacket>
    implements Channel<T> {
        private final AbstractMessenger messenger;
        private final String name;
        private final TypeToken<T> type;
        private final Codec<T> codec;
        private final Set<AbstractChannelAgent<T>> agents = ConcurrentHashMap.newKeySet();
        private boolean subscribed = false;

        private AbstractChannel(AbstractMessenger messenger, String name, TypeToken<T> type) {
            this.messenger = messenger;
            this.name = name;
            this.type = type;
            this.codec = new ByteArrayCodec<T>(AbstractMessenger.getCodec(type));
        }

        private void onIncomingMessage(byte[] message) {
            try {
                MessagePacket decoded = (MessagePacket)this.codec.decode(message);
                Objects.requireNonNull(decoded, "decoded");
                for (AbstractChannelAgent<MessagePacket> abstractChannelAgent : this.agents) {
                    try {
                        abstractChannelAgent.onIncomingMessage(abstractChannelAgent, decoded.getOriginServer(), decoded);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to agent: " + String.valueOf(decoded), e).printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                new RuntimeException("Unable to decode message: " + Base64.getEncoder().encodeToString(message), e).printStackTrace();
            }
        }

        private void checkSubscription() {
            boolean shouldSubscribe = this.agents.stream().anyMatch(AbstractChannelAgent::hasListeners);
            if (shouldSubscribe == this.subscribed) {
                return;
            }
            this.subscribed = shouldSubscribe;
            Schedulers.async().run(() -> {
                try {
                    if (shouldSubscribe) {
                        this.messenger.notifySub.accept(this.name);
                    } else {
                        this.messenger.notifyUnsub.accept(this.name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeToken<T> getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Codec<T> getCodec() {
            return this.codec;
        }

        @Override
        public ChannelAgent<T> newAgent() {
            AbstractChannelAgent agent = new AbstractChannelAgent(this);
            this.agents.add(agent);
            return agent;
        }

        @Override
        public Promise<Void> sendMessage(T message) {
            Objects.requireNonNull(message, "message");
            ((MessagePacket)message).setOriginServer(this.messenger.getServerName());
            return Schedulers.async().call(() -> {
                byte[] buf = this.codec.encode(message);
                this.messenger.outgoingMessages.accept(this.name, buf);
                return null;
            });
        }

        @Override
        public Promise<Void> sendMessage(String server, T message) {
            Objects.requireNonNull(server, "server");
            Objects.requireNonNull(message, "message");
            ((MessagePacket)message).setOriginServer(this.messenger.getServerName());
            return Schedulers.async().call(() -> {
                byte[] buf = this.codec.encode(message);
                this.messenger.outgoingToMessages.accept(server, this.name, buf);
                return null;
            });
        }

        public AbstractMessenger getMessenger() {
            return this.messenger;
        }
    }

    private static class AbstractChannelAgent<T extends MessagePacket>
    implements ChannelAgent<T> {
        @Nullable
        private AbstractChannel<T> channel;
        private final Set<ChannelListener<T>> listeners = ConcurrentHashMap.newKeySet();

        AbstractChannelAgent(AbstractChannel<T> channel) {
            this.channel = channel;
        }

        private void onIncomingMessage(ChannelAgent agent, String sender, T data) {
            for (ChannelListener listener : this.listeners) {
                Schedulers.async().run(() -> {
                    try {
                        listener.onMessage(agent, sender, data);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to listener: " + String.valueOf(listener), e).printStackTrace();
                    }
                });
            }
        }

        @Override
        public Channel<T> getChannel() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return this.channel;
        }

        @Override
        public Set<ChannelListener<T>> getListeners() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return ImmutableSet.copyOf(this.listeners);
        }

        @Override
        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }

        @Override
        public boolean addListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.add(listener);
                return bl;
            }
            finally {
                this.channel.checkSubscription();
            }
        }

        @Override
        public boolean removeListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.remove(listener);
                return bl;
            }
            finally {
                this.channel.checkSubscription();
            }
        }

        @Override
        public void close() {
            if (this.channel == null) {
                return;
            }
            this.listeners.clear();
            this.channel.agents.remove(this);
            this.channel.checkSubscription();
            this.channel = null;
        }
    }
}

