/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedDouble {
    protected final Operation op;
    protected double min;
    protected double max;

    public RangedDouble(String value) {
        this(value, false);
    }

    public RangedDouble(String value, boolean squared) {
        if (value.contains("to")) {
            split = value.split("to");
            this.min = Double.valueOf(split[0]);
            this.max = Double.valueOf(split[1]);
            this.op = Operation.RANGE;
        } else if (value.startsWith(">")) {
            s = value.substring(1);
            this.min = Double.valueOf(s);
            this.max = Double.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            s = value.substring(1);
            this.min = -1.7976931348623157E308;
            this.max = Double.valueOf(s);
            this.op = Operation.LESS_THAN;
        } else if (!value.startsWith("-") && value.contains("-")) {
            split = value.split("-");
            this.min = Integer.valueOf(split[0]).intValue();
            this.max = Integer.valueOf(split[1]).intValue();
            this.op = Operation.RANGE;
        } else {
            this.min = Double.valueOf(value);
            this.max = Double.valueOf(value);
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            double i = this.min;
            this.min = this.max;
            this.max = i;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof Integer || o instanceof Double || o instanceof Float) {
            double d = o instanceof Integer ? (double)((Integer)o).intValue() * 1.0 : (o instanceof Float ? (double)((Float)o).floatValue() * 1.0 : (Double)o);
            switch (this.op.ordinal()) {
                case 0: {
                    return d == this.min;
                }
                case 1: {
                    return d > this.min;
                }
                case 2: {
                    return d < this.max;
                }
                case 3: {
                    return d >= this.min && d <= this.max;
                }
            }
            return true;
        }
        return false;
    }

    public boolean equalsSquared(Object o) {
        if (o instanceof Integer || o instanceof Double || o instanceof Float) {
            double d = o instanceof Integer ? (double)((Integer)o).intValue() * 1.0 : (o instanceof Float ? (double)((Float)o).floatValue() * 1.0 : (Double)o);
            switch (this.op.ordinal()) {
                case 0: {
                    return d == Math.pow(this.min, 2.0);
                }
                case 1: {
                    return d > Math.pow(this.min, 2.0);
                }
                case 2: {
                    return d < Math.pow(this.max, 2.0);
                }
                case 3: {
                    return d >= Math.pow(this.min, 2.0) && d <= Math.pow(this.max, 2.0);
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "RangedDouble{" + this.min + " to " + this.max + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        LESS_THAN,
        RANGE;

    }
}

