/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles;

import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class Fireworks {
    private static List<Color> fireworkColors = new ArrayList<Color>();
    private static List<FireworkEffect.Type> fireworkTypes = new ArrayList<FireworkEffect.Type>();

    public static Firework spawn(Location location) {
        return Fireworks.spawn(location, Numbers.randomInt(5));
    }

    public static Firework spawn(Location location, int power) {
        Firework firework = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK_ROCKET);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        FireworkEffect.Type type = Fireworks.getRandomType();
        Color c1 = Fireworks.getRandomColor();
        Color c2 = Fireworks.getRandomColor();
        FireworkEffect effect = FireworkEffect.builder().flicker(Numbers.randomBoolean()).withColor(c1).withFade(c2).with(type).trail(Numbers.randomBoolean()).build();
        fireworkMeta.addEffect(effect);
        fireworkMeta.setPower(power);
        firework.setFireworkMeta(fireworkMeta);
        return firework;
    }

    private static FireworkEffect.Type getRandomType() {
        return fireworkTypes.get(Numbers.randomInt(fireworkTypes.size()));
    }

    private static Color getRandomColor() {
        return fireworkColors.get(Numbers.randomInt(fireworkColors.size()));
    }

    static {
        fireworkColors.add(Color.AQUA);
        fireworkColors.add(Color.YELLOW);
        fireworkColors.add(Color.BLACK);
        fireworkColors.add(Color.BLUE);
        fireworkColors.add(Color.FUCHSIA);
        fireworkColors.add(Color.GRAY);
        fireworkColors.add(Color.GREEN);
        fireworkColors.add(Color.LIME);
        fireworkColors.add(Color.MAROON);
        fireworkColors.add(Color.NAVY);
        fireworkColors.add(Color.OLIVE);
        fireworkColors.add(Color.ORANGE);
        fireworkColors.add(Color.PURPLE);
        fireworkColors.add(Color.RED);
        fireworkColors.add(Color.SILVER);
        fireworkColors.add(Color.TEAL);
        fireworkColors.add(Color.WHITE);
        fireworkTypes.add(FireworkEffect.Type.BALL);
        fireworkTypes.add(FireworkEffect.Type.BALL_LARGE);
        fireworkTypes.add(FireworkEffect.Type.BURST);
        fireworkTypes.add(FireworkEffect.Type.CREEPER);
        fireworkTypes.add(FireworkEffect.Type.STAR);
    }
}

