/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles.reflection;

import io.lumine.mythic.bukkit.utils.particles.reflection.ReflectionAccessor;
import io.lumine.mythic.bukkit.utils.particles.reflection.TransparentReflectionAccessor;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.Mappings;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedReflectionAccessor
implements ReflectionAccessor {
    @NotNull
    private final Mappings mappings;
    @NotNull
    private final Map<String, ClassHandle> classes = new HashMap<String, ClassHandle>();

    public MappedReflectionAccessor(@NotNull Mappings mappings) {
        this.mappings = mappings;
        for (Mappings.ClassMapping classMapping : mappings.getClasses()) {
            this.classes.put(classMapping.getOriginalName(), new ClassHandle(classMapping));
        }
    }

    @Override
    @NotNull
    public ClassHandle getClass(@NotNull String original) throws ClassNotFoundException {
        if (this.classes.containsKey(original)) {
            return this.classes.get(original);
        }
        throw new ClassNotFoundException(original);
    }

    protected Class<?>[] getClassesFromMappingTypes(Type[] handles) throws ClassNotFoundException {
        Class[] array = new Class[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            TypeDescriptor.OfField<Class<?>> type;
            Type type2 = handles[i];
            if (type2 instanceof Class) {
                Class<?> clazz;
                type = clazz = (Class<?>)type2;
            } else {
                type2 = handles[i];
                if (type2 instanceof Mappings.ClassMapping) {
                    Mappings.ClassMapping mapping = (Mappings.ClassMapping)type2;
                    type = this.getClass(mapping.getOriginalName()).getClassInstance();
                } else {
                    type2 = handles[i];
                    if (type2 instanceof ClassHandle) {
                        ClassHandle handle = (ClassHandle)type2;
                        type = handle.getClassInstance();
                    } else {
                        type2 = handles[i];
                        if (type2 instanceof Mappings.ClassMapping.ClassArrayType) {
                            Mappings.ClassMapping.ClassArrayType mappingArray = (Mappings.ClassMapping.ClassArrayType)type2;
                            type = this.getClassInstance(mappingArray.componentMapping().getTypeName()).arrayType();
                        } else {
                            throw new IllegalArgumentException(handles[i].getClass().toString());
                        }
                    }
                }
            }
            array[i] = type;
        }
        return array;
    }

    private class ClassHandle
    implements ReflectionAccessor.ClassAccessor {
        @NotNull
        private final Mappings.ClassMapping mapping;
        private final List<FieldHandle> fields;
        private final List<MethodHandle> methods;
        @Nullable
        private Mappings.ClassMapping.ClassArrayType cachedArrayType;
        @Nullable
        private Class<?> cachedClass;

        public ClassHandle(Mappings.ClassMapping mapping) {
            this.mapping = mapping;
            this.fields = mapping.getFields().stream().map(x$0 -> new FieldHandle((Mappings.ClassMapping.FieldMapping)x$0)).toList();
            this.methods = mapping.getMethods().stream().map(x$0 -> new MethodHandle((Mappings.ClassMapping.MethodMapping)x$0)).toList();
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.mapping.getOriginalName();
        }

        @Override
        @NotNull
        public Type getArrayType() {
            if (this.cachedArrayType == null) {
                this.cachedArrayType = this.mapping.getArrayType();
            }
            return this.cachedArrayType;
        }

        @Override
        @NotNull
        public Class<?> getClassInstance() throws ClassNotFoundException {
            if (this.cachedClass == null) {
                this.cachedClass = Class.forName(this.mapping.getMappedName());
            }
            return this.cachedClass;
        }

        @Override
        @NotNull
        public FieldHandle getField(@NotNull String original) throws NoSuchFieldException {
            for (FieldHandle field : this.fields) {
                if (!field.mapping.getOriginalName().equals(original)) continue;
                return field;
            }
            throw new NoSuchFieldException(original);
        }

        @Override
        @NotNull
        public MethodHandle getMethod(@NotNull String original, Type ... parameterTypes) throws NoSuchMethodException {
            for (MethodHandle method : this.methods) {
                if (!method.mapping.getOriginalName().equals(original) || !method.mapping.isSameParameters(parameterTypes)) continue;
                return method;
            }
            throw new NoSuchMethodException(Mappings.getStringForMethod(original, parameterTypes));
        }

        @Override
        @NotNull
        public ReflectionAccessor.ClassAccessor.ConstructorAccessor getConstructor(Type ... parameterTypes) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
            Constructor<?> constructor = this.getClassInstance().getDeclaredConstructor(MappedReflectionAccessor.this.getClassesFromMappingTypes(parameterTypes));
            return new TransparentReflectionAccessor.TransparentConstructor(constructor);
        }

        private class FieldHandle
        implements ReflectionAccessor.ClassAccessor.FieldAccessor {
            @NotNull
            private final Mappings.ClassMapping.FieldMapping mapping;
            @Nullable
            private Field cachedField;

            private FieldHandle(Mappings.ClassMapping.FieldMapping mapping) {
                this.mapping = mapping;
            }

            @Override
            @NotNull
            public Field getFieldInstance() throws NoSuchFieldException, SecurityException, ClassNotFoundException {
                if (this.cachedField == null) {
                    this.cachedField = ClassHandle.this.getClassInstance().getDeclaredField(this.mapping.getMappedName());
                    this.cachedField.setAccessible(true);
                }
                return this.cachedField;
            }

            @Override
            public Object get(@Nullable Object instance) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
                return this.getFieldInstance().get(instance);
            }

            @Override
            public void set(@Nullable Object instance, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
                this.getFieldInstance().set(instance, value);
            }
        }

        private class MethodHandle
        implements ReflectionAccessor.ClassAccessor.MethodAccessor {
            @NotNull
            private final Mappings.ClassMapping.MethodMapping mapping;
            @Nullable
            private Method cachedMethod;

            private MethodHandle(Mappings.ClassMapping.MethodMapping mapping) {
                this.mapping = mapping;
            }

            @Override
            @NotNull
            public Method getMethodInstance() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
                if (this.cachedMethod == null) {
                    this.cachedMethod = ClassHandle.this.getClassInstance().getDeclaredMethod(this.mapping.getMappedName(), MappedReflectionAccessor.this.getClassesFromMappingTypes(this.mapping.getParameterTypes()));
                    this.cachedMethod.setAccessible(true);
                }
                return this.cachedMethod;
            }

            @Override
            public Object invoke(@Nullable Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
                return this.getMethodInstance().invoke(instance, args);
            }
        }
    }
}

