/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis;

import io.lumine.mythic.bukkit.utils.redis.jedis.HostAndPort;
import io.lumine.mythic.bukkit.utils.redis.jedis.HostAndPortMapper;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisClientConfig;
import io.lumine.mythic.bukkit.utils.redis.jedis.JedisSocketFactory;
import io.lumine.mythic.bukkit.utils.redis.jedis.exceptions.JedisConnectionException;
import io.lumine.mythic.bukkit.utils.redis.jedis.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultJedisSocketFactory
implements JedisSocketFactory {
    protected static final HostAndPort DEFAULT_HOST_AND_PORT = new HostAndPort("localhost", 6379);
    private volatile HostAndPort hostAndPort = DEFAULT_HOST_AND_PORT;
    private int connectionTimeout = 2000;
    private int socketTimeout = 2000;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = null;
    private SSLParameters sslParameters = null;
    private HostnameVerifier hostnameVerifier = null;
    private HostAndPortMapper hostAndPortMapper = null;

    public DefaultJedisSocketFactory() {
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort) {
        this(hostAndPort, null);
    }

    public DefaultJedisSocketFactory(JedisClientConfig config) {
        this(null, config);
    }

    @Deprecated
    public DefaultJedisSocketFactory(String host, int port, int connectionTimeout, int socketTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.hostAndPort = new HostAndPort(host, port);
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort, JedisClientConfig config) {
        if (hostAndPort != null) {
            this.hostAndPort = hostAndPort;
        }
        if (config != null) {
            this.connectionTimeout = config.getConnectionTimeoutMillis();
            this.socketTimeout = config.getSocketTimeoutMillis();
            this.ssl = config.isSsl();
            this.sslSocketFactory = config.getSslSocketFactory();
            this.sslParameters = config.getSslParameters();
            this.hostnameVerifier = config.getHostnameVerifier();
            this.hostAndPortMapper = config.getHostAndPortMapper();
        }
    }

    @Override
    public Socket createSocket() throws JedisConnectionException {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            HostAndPort hostAndPort = this.getSocketHostAndPort();
            socket.connect(new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort()), this.getConnectionTimeout());
            socket.setSoTimeout(this.getSoTimeout());
            if (this.ssl) {
                HostnameVerifier hostnameVerifier;
                SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
                if (null == sslSocketFactory) {
                    sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                socket = sslSocketFactory.createSocket(socket, hostAndPort.getHost(), hostAndPort.getPort(), true);
                SSLParameters sslParameters = this.getSslParameters();
                if (null != sslParameters) {
                    ((SSLSocket)socket).setSSLParameters(sslParameters);
                }
                if (null != (hostnameVerifier = this.getHostnameVerifier()) && !hostnameVerifier.verify(hostAndPort.getHost(), ((SSLSocket)socket).getSession())) {
                    String message = String.format("The connection to '%s' failed ssl/tls hostname verification.", hostAndPort.getHost());
                    throw new JedisConnectionException(message);
                }
            }
            return socket;
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(socket);
            throw new JedisConnectionException("Failed to create socket.", ex);
        }
    }

    @Override
    public void updateHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public HostAndPort getSocketHostAndPort() {
        HostAndPort mapped;
        HostAndPortMapper mapper = this.getHostAndPortMapper();
        HostAndPort hostAndPort = this.getHostAndPort();
        if (mapper != null && (mapped = mapper.getHostAndPort(hostAndPort)) != null) {
            return mapped;
        }
        return hostAndPort;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    @Deprecated
    public void setHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    @Override
    public String getDescription() {
        return this.hostAndPort.toString();
    }

    @Override
    public String getHost() {
        return this.hostAndPort.getHost();
    }

    @Override
    @Deprecated
    public void setHost(String host) {
        this.hostAndPort = new HostAndPort(host, this.hostAndPort.getPort());
    }

    @Override
    public int getPort() {
        return this.hostAndPort.getPort();
    }

    @Override
    @Deprecated
    public void setPort(int port) {
        this.hostAndPort = new HostAndPort(this.hostAndPort.getHost(), port);
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    @Deprecated
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.socketTimeout;
    }

    @Override
    @Deprecated
    public void setSoTimeout(int soTimeout) {
        this.socketTimeout = soTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    @Deprecated
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Deprecated
    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    @Deprecated
    public void setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Deprecated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HostAndPortMapper getHostAndPortMapper() {
        return this.hostAndPortMapper;
    }

    @Deprecated
    public void setHostAndPortMapper(HostAndPortMapper hostAndPortMapper) {
        this.hostAndPortMapper = hostAndPortMapper;
    }

    public String toString() {
        return "DefaultJedisSocketFactory{" + this.hostAndPort.toString() + "}";
    }
}

