/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis.params;

import io.lumine.mythic.bukkit.utils.redis.jedis.HostAndPort;
import io.lumine.mythic.bukkit.utils.redis.jedis.Protocol;
import io.lumine.mythic.bukkit.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;

public class FailoverParams {
    private HostAndPort to;
    private boolean force;
    private Long timeout;

    public static FailoverParams failoverParams() {
        return new FailoverParams();
    }

    public FailoverParams to(String host, int port) {
        return this.to(new HostAndPort(host, port));
    }

    public FailoverParams to(HostAndPort to) {
        this.to = to;
        return this;
    }

    public FailoverParams force() {
        this.force = true;
        return this;
    }

    public FailoverParams timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public byte[][] getByteParams() {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        if (this.to != null) {
            params.add(Protocol.Keyword.TO.getRaw());
            params.add(SafeEncoder.encode(this.to.getHost()));
            params.add(Protocol.toByteArray(this.to.getPort()));
        }
        if (this.force) {
            if (this.to == null || this.timeout == null) {
                throw new IllegalStateException("ERR FAILOVER with force option requires both a timeout and target HOST and IP.");
            }
            params.add(Protocol.Keyword.FORCE.getRaw());
        }
        if (this.timeout != null) {
            params.add(Protocol.Keyword.TIMEOUT.getRaw());
            params.add(Protocol.toByteArray(this.timeout));
        }
        return (byte[][])params.toArray((T[])new byte[params.size()][]);
    }
}

