/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.placeholders.PlaceholderVector;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.LineConfig;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.core.config.GenericConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderColorImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MythicLineConfigImpl
extends LineConfig
implements GenericConfig,
MythicLineConfig {
    private static final Pattern STRING_LIST_PATTERN = Pattern.compile("(?:\\[.+?\\]|\\(.+?\\)|\\{.+?\\}|[^,])+?(?=\\s*,|\\z)");

    public static MythicLineConfigImpl of(String line) {
        return new MythicLineConfigImpl(line);
    }

    public static MythicLineConfigImpl of(File file, String line) {
        return new MythicLineConfigImpl(line);
    }

    public MythicLineConfigImpl(String fileName, String line) {
        super(fileName, line);
    }

    public MythicLineConfigImpl(File file, String line) {
        super(file, line);
    }

    public MythicLineConfigImpl(String s2) {
        super(s2);
    }

    @Override
    public Boolean getBooleanNullable(String key) {
        String str = this.getString(key, null);
        if (str == null) {
            return null;
        }
        try {
            return Boolean.valueOf(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public Boolean getBooleanNullable(String[] key) {
        String str = this.getString(key, null, new String[0]);
        if (str == null) {
            return null;
        }
        try {
            return Boolean.valueOf(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String key) {
        String str = this.getString(key, null);
        if (str == null) {
            return null;
        }
        try {
            return PlaceholderBoolean.of(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String[] key) {
        String str = this.getString(key, null, new String[0]);
        if (str == null) {
            return null;
        }
        try {
            return PlaceholderBoolean.of(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String key, Boolean def) {
        String str = this.getString(key, def == null ? null : def.toString());
        if (str == null) {
            return null;
        }
        try {
            return PlaceholderBoolean.of(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public PlaceholderBoolean getPlaceholderBoolean(String[] key, Boolean def) {
        String str = this.getString(key, def == null ? null : def.toString(), new String[0]);
        if (str == null) {
            return null;
        }
        try {
            return PlaceholderBoolean.of(str);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public Chroma getColor(String key) {
        String value = this.getString(key, null);
        if (value != null) {
            return Chroma.of(value);
        }
        return null;
    }

    @Override
    public Chroma getColor(String key, Chroma def) {
        String value = this.getString(key, null);
        if (value != null) {
            return Chroma.of(value);
        }
        return def;
    }

    @Override
    public Chroma getColor(String[] keys) {
        for (String key : keys) {
            String value = this.getString(key, null);
            if (value == null) continue;
            return Chroma.of(value);
        }
        return null;
    }

    @Override
    public Chroma getColor(String[] keys, Chroma def) {
        for (String key : keys) {
            String value = this.getString(key, null);
            if (value == null) continue;
            return Chroma.of(value);
        }
        return null;
    }

    @Override
    public PlaceholderString getPlaceholderString(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public PlaceholderString getPlaceholderString(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String key, PlaceholderInt def) {
        String s2 = this.getString(key, null);
        if (s2 == null) {
            return def;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String[] key, PlaceholderInt def, String ... args) {
        String s2 = this.getString(key, null, args);
        if (s2 == null) {
            return def;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String key, int def) {
        return this.getPlaceholderInteger(key, String.valueOf(def));
    }

    @Override
    public PlaceholderInt getPlaceholderInteger(String[] key, int def, String ... args) {
        return this.getPlaceholderInteger(key, String.valueOf(def), args);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String key, double def) {
        return this.getPlaceholderDouble(key, String.valueOf(def));
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String[] key, double def, String ... args) {
        return this.getPlaceholderDouble(key, String.valueOf(def), args);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String key, PlaceholderDouble def) {
        String s2 = this.getString(key, null);
        if (s2 == null) {
            return def;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String[] key, PlaceholderDouble def, String ... args) {
        String s2 = this.getString(key, null, args);
        if (s2 == null) {
            return def;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderFloat getPlaceholderFloat(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderFloat.of(s2);
    }

    @Override
    public PlaceholderFloat getPlaceholderFloat(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderFloat.of(s2);
    }

    @Override
    public PlaceholderFloat getPlaceholderFloat(String key, float def) {
        return this.getPlaceholderFloat(key, String.valueOf(def));
    }

    @Override
    public PlaceholderFloat getPlaceholderFloat(String[] key, float def, String ... args) {
        return this.getPlaceholderFloat(key, String.valueOf(def), args);
    }

    @Override
    public PlaceholderColorImpl getPlaceholderColor(String key, String def) {
        PlaceholderString s2 = this.getPlaceholderString(key, def);
        if (s2 == null) {
            return null;
        }
        return new PlaceholderColorImpl(s2);
    }

    @Override
    public PlaceholderColorImpl getPlaceholderColor(String[] key, String def, String ... args) {
        PlaceholderString s2 = this.getPlaceholderString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return new PlaceholderColorImpl(s2);
    }

    @Override
    public PlaceholderVector getPlaceholderVector(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderVector.of(s2);
    }

    @Override
    public PlaceholderVector getPlaceholderVector(String[] key, String def) {
        String s2 = this.getString(key, def, new String[0]);
        if (s2 == null) {
            return null;
        }
        return PlaceholderVector.of(s2);
    }

    @Override
    public PlaceholderVector getPlaceholderVector(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderVector.of(s2);
    }

    @Override
    public SkillAudience getAudience(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return MythicBukkit.inst().getSkillManager().getAudience(s2);
    }

    @Override
    public SkillAudience getAudience(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return MythicBukkit.inst().getSkillManager().getAudience(s2);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String[] key, Class<T> clazz, T def) {
        try {
            String in = this.getString(key);
            if (in == null) {
                return def;
            }
            return Enum.valueOf(clazz, in.toUpperCase());
        }
        catch (Error | Exception ex) {
            return def;
        }
    }

    @Override
    public <T extends Enum<T>> T getEnum(String[] key, Class<T> clazz, T def, String errorMessage) {
        try {
            String in = this.getString(key);
            if (in == null) {
                return def;
            }
            return Enum.valueOf(clazz, in.toUpperCase());
        }
        catch (Error | Exception ex) {
            MythicLogger.errorGenericConfig(this, errorMessage);
            return def;
        }
    }

    @Override
    public List<String> parseStringList(String in) {
        Matcher matcher = STRING_LIST_PATTERN.matcher(in);
        ArrayList found = Lists.newArrayList();
        while (matcher.find()) {
            String item = matcher.group().trim();
            found.add(item);
        }
        return found;
    }

    @Override
    public List<String> getStringList(String key, String def) {
        return this.parseStringList(this.getString(key, def));
    }

    @Override
    public List<String> getStringList(String[] key, String def) {
        return this.parseStringList(this.getString(key, def, new String[0]));
    }

    @Override
    public List<String> getStringList(String[] key, String def, String ... args) {
        return this.parseStringList(this.getString(key, def, args));
    }

    public static String unparseBlock(String s2) {
        String ns;
        int i;
        String[] split;
        if (s2.contains("\"")) {
            split = s2.split("\"");
            i = 0;
            ns = "";
            for (String ss : split) {
                ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                ++i;
            }
            s2 = ns;
        }
        if (s2.contains("'")) {
            split = s2.split("'");
            i = 0;
            ns = "";
            for (String ss : split) {
                ns = i % 2 == 1 ? ns.concat("'" + SkillString.unparseMessageSpecialChars(ss) + "'") : ns.concat(ss);
                ++i;
            }
            s2 = ns;
        }
        int pos = 0;
        int count = 0;
        int ss = 0;
        int sc = 0;
        int ec = 0;
        Object parsed = "";
        for (char c : s2.toCharArray()) {
            if (c == '{') {
                if (count == 0) {
                    sc = pos;
                }
                ++count;
            }
            if (c == '}' && --count == 0) {
                ec = pos;
                String f = s2.substring(ss, sc);
                String m4 = s2.substring(sc, ec).replace(" ", "<&csp>").replace("-", "<&da>");
                String e = s2.substring(ec);
                parsed = (String)parsed + f + m4;
                ss = pos;
            }
            ++pos;
        }
        parsed = (String)parsed + s2.substring(ss, pos);
        return parsed;
    }

    public static String parseBlock(String s2) {
        return s2.replace("<&csp>", " ").replace("<&da>", "-").trim();
    }
}

