/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ItemEditorMenu
extends MythicMenu<ItemEditorMenuContext> {
    private ItemEditorButtons buttons = new ItemEditorButtons();

    public ItemEditorMenu(MythicBukkit plugin, MenuManager manager) {
        super(plugin, manager, "/menus/item-editor.yml");
    }

    @Override
    public void open(Player player, MythicItem mythicItem) {
        this.open(player, new ItemEditorMenuContext(mythicItem, new ItemMenuContext()));
    }

    @Override
    public void open(Player player, ItemEditorMenuContext context) {
        ArrayList buttons = Lists.newArrayList(this.buttons.getButtons());
        buttons.removeIf(itemButton -> !itemButton.isApplicable(context.getItem()));
        this.open(player, context, Text.colorize("Editing Item: " + context.getItem().getInternalName()), buttons);
    }

    @Override
    public EditableMenuBuilder<ItemEditorMenuContext> build(EditableMenuBuilder<ItemEditorMenuContext> builder) {
        builder = this.addPageButtons(builder);
        builder.getIcon("BACK_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> context.openPreviousMenu((Player)player)));
        builder.getIcon("ITEM_BUTTON").ifPresent(icon -> icon.getBuilder().itemStack(context -> context.getItem().getCachedMenuItem()).hideFlags(false).click((context, player) -> {
            player.performCommand("mythicmobs i get " + context.getItem().getInternalName());
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }));
        builder.getIcon("DELETE_BUTTON").ifPresent(icon -> icon.getBuilder().hideFlags(false).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type <red>DELETE <white>to confirm deleting", "Type anything else to abort");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (!input.equals("DELETE")) {
                    context.openMenu((Player)player);
                    return ChatPrompt.Response.ACCEPTED;
                }
                MythicItem item = context.getItem();
                this.getPlugin().getItemManager().deleteItem(item);
                context.openPreviousMenu((Player)player);
                player.playSound(player.getLocation(), "entity.zombie.break_wooden_door", 1.0f, 1.0f);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> {});
        }));
        return builder;
    }
}

