/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.mobs.MobEditorButton;
import io.lumine.mythic.core.menus.mobs.MobEditorButtons;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditTypeButton
extends MobEditorButton {
    public EditTypeButton(MobEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<MobEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.PIG_SPAWN_EGG).name("<green>Set Type").lore(context -> Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>" + String.valueOf((Object)context.getMob().getEntityType())})).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the entity type you'd like to use.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                MythicEntityType entityType = MythicEntityType.get(input);
                if (entityType == null) {
                    CommandHelper.sendError((CommandSender)player, "Failed to set entity type: invalid type specified.");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                context.getMob().setEntityType(entityType);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).build();
    }
}

