/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.mechanics.CastMechanic;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.SudoSkillMechanic;
import io.lumine.mythic.core.skills.targeters.IPathSelector;
import io.lumine.mythic.core.skills.targeters.MPEntity;
import io.lumine.mythic.core.skills.targeters.MPLocation;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;

public class SkillMechanic
extends AbstractSkill
implements ISkillMechanic {
    protected final MythicLineConfig config;
    protected Optional<SkillHolder> parent = Optional.empty();
    protected int interval = 0;
    protected long clock = 0L;
    protected String line;
    @MythicField(name="forceSync", aliases={"sync"}, description="Sets the execution of the mechanic to the main thread instead of async.")
    protected boolean forceSync = false;
    protected boolean executeAfterDeath = false;
    @MythicField(name="targetIsOrigin", description="Sets the origin to the target's location instead of the caster's")
    protected boolean targetIsOrigin = false;
    @MythicField(name="origin", description="Sets the origin of the skill", premium=true)
    protected Optional<SkillTargeter> originOverride;
    private static ConcurrentHashMap<Class, String> typeNameCache = new ConcurrentHashMap();

    public SkillMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc, int interval) {
        super(manager, file);
        this.config = mlc;
        this.interval = interval + (((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain() - interval % ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain());
        this.init(line, mlc);
    }

    public SkillMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file);
        this.config = mlc;
        this.init(line, mlc);
    }

    @Deprecated
    public SkillMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        this(manager, null, line, mlc);
    }

    public SkillMechanic(SkillExecutor manager, File file) {
        super(manager, file);
        this.config = null;
        this.line = "[internal]";
        this.originOverride = Optional.empty();
    }

    private void init(String line, MythicLineConfig mlc) {
        String cd2 = mlc.getString(new String[]{"cooldown", "cd"}, null, new String[0]);
        if (cd2 != null) {
            this.cooldown = PlaceholderDouble.of(cd2);
        }
        this.delay = mlc.getPlaceholderInteger("delay", 0);
        this.targetInterval = mlc.getPlaceholderDouble(new String[]{"targetinterval", "targeti"}, 0.0, new String[0]);
        this.repeat = mlc.getPlaceholderInteger("repeat", 0);
        this.repeatInterval = mlc.getPlaceholderInteger(new String[]{"repeatinterval", "repeati"}, 0, new String[0]);
        this.power = mlc.getFloat("power", 1.0f);
        this.powerSplitBetweenTargets = mlc.getBoolean(new String[]{"powersplitbetweentargets", "powersplit", "splitpower"}, false);
        this.forceSync = mlc.getBoolean(new String[]{"forcesync", "sync"}, false);
        this.targetIsOrigin = mlc.getBoolean("targetisorigin", false);
        this.sourceIsOrigin = mlc.getBoolean(new String[]{"sourceisorigin", "castfromorigin", "fromorigin", "fo"}, false);
        this.faulty = mlc.getBoolean(new String[]{"faulty"}, true);
        String originOverride = mlc.getString("origin", null);
        this.originOverride = originOverride != null && MythicBukkit.isVolatile() ? Optional.of(this.parseSkillTargeter(originOverride)) : Optional.empty();
        this.target_creative = mlc.getBoolean("targetcreative", this.target_creative);
        this.chance = mlc.getFloat("chance", 1.0f);
        String[] split = line.split(" ");
        for (int i = 1; i < split.length; ++i) {
            SkillCondition cond;
            if (split[i].startsWith("@")) {
                this.targeter = Optional.of(this.parseSkillTargeter(split[i]));
                this.targeter.ifPresent(tar -> tar.setParent(this));
                continue;
            }
            if (split[i].startsWith("~")) {
                this.trigger = this.parseSkillTrigger(split[i]);
                continue;
            }
            if (split[i].startsWith("=") || split[i].startsWith(">") || split[i].startsWith("<")) {
                this.healthMod = split[i];
                continue;
            }
            if (split[i].startsWith("?~")) {
                if (this.conditionsTrigger == null) {
                    this.conditionsTrigger = new ObjectArrayList();
                }
                cond = this.parseSkillCondition(split[i].substring(1));
                cond.setParent(this);
                this.conditionsTrigger.add(cond);
                continue;
            }
            if (split[i].startsWith("?")) {
                if (this.conditions == null) {
                    this.conditions = new ObjectArrayList();
                }
                cond = this.parseSkillCondition(split[i]);
                cond.setParent(this);
                this.conditions.add(cond);
                continue;
            }
            if (!split[i].matches("[0-9]*[.]?[0-9]+")) continue;
            this.chance = Float.parseFloat(split[i]);
        }
        if (this.trigger == null) {
            this.trigger = SkillTriggers.COMBAT;
        }
    }

    @Override
    public String getInternalName() {
        if (this.parent.isPresent()) {
            return this.parent.get().getInternalName() + ":" + this.getTypeName();
        }
        return "Unknown:" + this.getTypeName();
    }

    public String getTypeName() {
        SkillMechanic skillMechanic = this;
        if (skillMechanic instanceof CustomMechanic) {
            CustomMechanic customMechanic = (CustomMechanic)skillMechanic;
            ISkillMechanic mechanic = customMechanic.getMechanic().orElse(null);
            if (mechanic == null) {
                return "CustomMechanic:NULL";
            }
            Class<?> clazz = mechanic.getClass();
            Object typeName = typeNameCache.get(clazz);
            if (typeName != null) {
                return typeName;
            }
            typeName = clazz.isAnnotationPresent(MythicMechanic.class) ? "CustomMechanic:" + clazz.getAnnotation(MythicMechanic.class).name() : "CustomMechanic:" + clazz.getSimpleName();
            typeNameCache.put(clazz, (String)typeName);
            return typeName;
        }
        Class<?> clazz = this.getClass();
        String typeName = typeNameCache.get(clazz);
        if (typeName != null) {
            return typeName;
        }
        typeName = clazz.isAnnotationPresent(MythicMechanic.class) ? clazz.getAnnotation(MythicMechanic.class).name() : clazz.getSimpleName();
        typeNameCache.put(clazz, typeName);
        return typeName;
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setParent(SkillHolder parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public void setAsyncSafe(boolean bool) {
        this.threadSafetyLevel = bool ? ThreadSafetyLevel.EITHER : ThreadSafetyLevel.SYNC_ONLY;
    }

    public boolean isAsyncSafe() {
        return this.threadSafetyLevel != ThreadSafetyLevel.SYNC_ONLY;
    }

    public void setTimerInterval(int interval) {
        this.interval = interval;
    }

    public int getTimerInterval() {
        return this.interval;
    }

    public void resetClock() {
        this.clock = 0L;
    }

    public void tickClock() {
        this.clock += (long)((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain();
    }

    public long getClock() {
        return this.clock;
    }

    public boolean isUsableFromSkill(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (!mc.evaluateTrigger(meta)) {
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerCondition {0} failed", mc.getTypeName());
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (!mc.evaluateCaster(meta)) {
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Condition {0} failed", mc.getTypeName());
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic {0} is usable!", this.getTypeName());
        return true;
    }

    public boolean isUsableFromCaster(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.checkSkillTrigger(meta)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (!mc.evaluateTrigger(meta)) {
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerCondition {0} failed", mc.getTypeName());
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (!mc.evaluateCaster(meta)) {
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Condition {0} failed", mc.getTypeName());
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillMetadata meta) {
        return this.isUsableFromCaster(meta);
    }

    @Deprecated
    public boolean usable(SkillCaster skillCaster, SkillTrigger trigger) {
        if (!this.checkSkillTrigger(trigger)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillCaster am) {
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (am instanceof ActiveMob && !this.checkHealth(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    public boolean execute(SkillMetadata oData) {
        final SkillMetadata data = oData.deepClone();
        if (this.originOverride.isPresent()) {
            data.setOrigin(((MythicBukkit)this.getPlugin()).getSkillManager().getLocationTarget(this.originOverride.get(), oData));
        }
        final int delay = this.delay.get(oData);
        double targetInterval = this.targetInterval.get(oData);
        final int repeat = this.repeat.get(oData);
        final int repeatInterval = this.repeatInterval.get(oData);
        if (repeat > 0 && repeatInterval > 0) {
            final SkillMechanic skill = this;
            new Runnable(){
                private int ticks = 0;
                private final int repeats = repeat;
                private final Task task = Schedulers.sync().runRepeating(this, (long)delay, (long)repeatInterval);
                final /* synthetic */ SkillMechanic this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ++this.ticks;
                    try {
                        SkillMetadata meta = data.deepClone();
                        meta.getVariables().putInt("interval", this.ticks);
                        meta.getVariables().putInt("itr", this.ticks);
                        skill.executeSkills(meta);
                        if (this.ticks > this.repeats) {
                            this.task.terminate();
                        }
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                        this.task.terminate();
                    }
                }
            };
            return true;
        }
        if (repeat > 0 && repeatInterval == 0) {
            for (int i = 1; i <= repeat; ++i) {
                try {
                    SkillMetadata meta = data.deepClone();
                    meta.getVariables().putInt("interval", i);
                    meta.getVariables().putInt("itr", i);
                    this.executeSkills(meta);
                    continue;
                }
                catch (Error | Exception ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }
        if (targetInterval > 0.0) {
            SkillMechanic skill;
            SkillMetadata thisData;
            ObjectArrayList thisCastTargets;
            ObjectArrayList entityTargets = oData.getEntityTargets().isEmpty() ? Collections.emptyList() : new ObjectArrayList(oData.getEntityTargets());
            ObjectArrayList locationTargets = oData.getLocationTargets().isEmpty() ? Collections.emptyList() : new ObjectArrayList(oData.getLocationTargets());
            int intervalDelay = targetInterval < 1.0 ? 1 : (int)targetInterval;
            int amountPerTick = targetInterval >= 1.0 ? 1 : (int)(1.0 / targetInterval);
            int j = 1;
            while (entityTargets.size() > 0) {
                if (entityTargets.size() < amountPerTick) {
                    amountPerTick = entityTargets.size();
                }
                thisCastTargets = new ObjectArrayList();
                for (int i = 0; i < amountPerTick; ++i) {
                    thisCastTargets.add((Object)((AbstractEntity)entityTargets.get(0)));
                    entityTargets.remove(0);
                }
                thisData = data.deepClone();
                thisData.setEntityTargets((Collection<AbstractEntity>)thisCastTargets);
                thisData.getLocationTargets().clear();
                skill = this;
                Schedulers.sync().runLater(() -> skill.executeSkills(thisData), (long)j * (long)intervalDelay);
                ++j;
            }
            j = 1;
            while (locationTargets.size() > 0) {
                if (locationTargets.size() < amountPerTick) {
                    amountPerTick = locationTargets.size();
                }
                thisCastTargets = new ObjectArrayList();
                for (int i = 0; i < amountPerTick; ++i) {
                    thisCastTargets.add((Object)((AbstractLocation)locationTargets.get(0)));
                    locationTargets.remove(0);
                }
                thisData = data.deepClone();
                thisData.setLocationTargets((Collection<AbstractLocation>)thisCastTargets);
                thisData.getEntityTargets().clear();
                skill = this;
                Schedulers.sync().runLater(() -> skill.executeSkills(thisData), (long)j * (long)intervalDelay);
                ++j;
            }
            return true;
        }
        if (delay == 0) {
            return this.executeSkills(data);
        }
        SkillMechanic skill = this;
        Schedulers.sync().runLater(() -> skill.executeSkills(data), delay);
        return true;
    }

    public boolean executeSkills(SkillTrigger skilltrigger, ActiveMob am, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadataImpl data = new SkillMetadataImpl(skilltrigger, am, trigger, origin, eTargets, lTargets, power);
        return this.executeSkills(data);
    }

    public boolean executeSkills(SkillMetadata data) {
        ISkillMechanic mechanic;
        if (!data.getExecuteAfterDeath()) {
            if (this.executeAfterDeath) {
                data.setExecuteAfterDeath(true);
            } else {
                ActiveMob am;
                SkillCaster skillCaster = data.getCaster();
                if (skillCaster instanceof ActiveMob && (am = (ActiveMob)skillCaster).isDead()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Caster is dead, cancelling execution (line: {0})", this.line);
                    return false;
                }
            }
        }
        if (data.getOrigin() == null) {
            data.setOrigin(data.getCaster().getEntity().getLocation());
        }
        data.setPower(data.getPower() * this.power);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Executing SkillMechanic {0} with power {1} (line: {2})", this.getTypeName(), Float.valueOf(data.getPower()), this.line);
        this.evaluateTargets(data);
        if (this instanceof SudoSkillMechanic) {
            ((SudoSkillMechanic)this).cast(data);
            this.triggerCooldown(data);
            return true;
        }
        if (this instanceof CustomMechanic && ((CustomMechanic)this).getMechanic().isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a CUSTOM mechanic", new Object[0]);
            mechanic = ((CustomMechanic)this).getMechanic().get();
        } else {
            mechanic = this;
        }
        if (mechanic instanceof IMetaSkill) {
            IMetaSkill metaSkill = (IMetaSkill)mechanic;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a META mechanic. Executing...", new Object[0]);
            metaSkill.cast(data);
            this.triggerCooldown(data);
            return true;
        }
        if (mechanic instanceof ITargetedEntitySkill && mechanic instanceof ITargetedLocationSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic accepts multiple types...", new Object[0]);
            if (this.targeter.isPresent() && this.targeter.get() instanceof IPathSelector) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Targeter is PATH SELECTOR", new Object[0]);
                if (this.targeter.get() instanceof MPEntity) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as ENTITY skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedEntitySkill(mechanic, data, this.targetIsOrigin);
                    this.triggerCooldown(data);
                    return true;
                }
                if (this.targeter.get() instanceof MPLocation) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as LOCATION skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin);
                    this.triggerCooldown(data);
                    return true;
                }
            }
        }
        if (mechanic instanceof ITargetedEntitySkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Mechanic is ITargetedEntitySkill", new Object[0]);
            if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic {0} is an ENTITY skill. Executing...", mechanic.getClass().getName());
                this.runMechanic(data, () -> SkillMechanic.executeTargetedEntitySkill(mechanic, data, this.targetIsOrigin));
                this.triggerCooldown(data);
                return true;
            }
        }
        if (mechanic instanceof ITargetedLocationSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Mechanic is ITargetedLocationSkill", new Object[0]);
            if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin));
                this.triggerCooldown(data);
                return true;
            }
            if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as ENTITY_LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin));
                this.triggerCooldown(data);
                return true;
            }
        }
        if (mechanic instanceof INoTargetSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic runnable with no targets. Executing...", new Object[0]);
            this.runMechanic(data, () -> SkillMechanic.executeNoTargetSkill(mechanic, data));
            this.triggerCooldown(data);
            return true;
        }
        if (mechanic instanceof CastMechanic) {
            CastMechanic castMechanic = (CastMechanic)mechanic;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "- SkillMechanic is a CAST mechanic. Executing NoTargets fallback.", new Object[0]);
            castMechanic.failNoTargets(data);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "! No applicable targets available for mechanic {0}. Cancelling.", this.getTypeName());
        return false;
    }

    private void runMechanic(SkillMetadata data, Runnable run) {
        if ((data.getIsAsync() || !Bukkit.isPrimaryThread()) && this.threadSafetyLevel == ThreadSafetyLevel.SYNC_ONLY) {
            Schedulers.sync().run(run);
        } else if ((!data.getIsAsync() || Bukkit.isPrimaryThread()) && this.threadSafetyLevel == ThreadSafetyLevel.ASYNC_ONLY) {
            Schedulers.async().run(run);
        } else {
            run.run();
        }
    }

    protected static void executeTargetedEntitySkill(ISkillMechanic mechanic, SkillMetadata data, boolean targetIsOrigin) {
        ArrayList targets = Lists.newArrayList(data.getEntityTargets());
        targets.forEach(target -> {
            if (targetIsOrigin) {
                ((ITargetedEntitySkill)mechanic).castAtEntity(data.deepClone().setOrigin(target.getLocation()), (AbstractEntity)target);
            } else {
                ((ITargetedEntitySkill)mechanic).castAtEntity(data, (AbstractEntity)target);
            }
        });
    }

    protected static void executeTargetedLocationSkill(ISkillMechanic mechanic, SkillMetadata data, boolean targetIsOrigin) {
        if (data.getLocationTargets() != null) {
            data.getLocationTargets().forEach(target -> {
                if (targetIsOrigin) {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data.deepClone().setOrigin((AbstractLocation)target), (AbstractLocation)target);
                } else {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data, (AbstractLocation)target);
                }
            });
        } else if (data.getEntityTargets() != null) {
            data.getEntityTargets().forEach(entity -> {
                AbstractLocation target = entity.getLocation();
                if (targetIsOrigin) {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data.deepClone().setOrigin(target), target);
                } else {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data, target);
                }
            });
        }
    }

    protected static void executeNoTargetSkill(ISkillMechanic mechanic, SkillMetadata data) {
        ((INoTargetSkill)mechanic).cast(data);
    }

    public boolean getRunAsync() {
        return !this.forceSync;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public Optional<SkillHolder> getParent() {
        return this.parent;
    }
}

