/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.numbers.RangedInt;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Phil", name="HasItem", aliases={}, description="Checks the inventory for this item")
public class HasItemCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition {
    private String itemName;
    @MythicField(name="types", aliases={"types", "type", "t", "material", "mat", "m", "item", "i"}, description="A list of materials to check")
    private AbstractItemMatcher matcher;
    @MythicField(name="amount", aliases={"a"}, description="The amount to check for")
    private final RangedInt amount;

    public HasItemCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = new RangedInt(mlc.getString(new String[]{"amount", "a"}, ">0", new String[0]));
        this.matcher = HasItemCondition.getPlugin().getBootstrap().getItemMatcher(mlc, this.conditionVar);
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        if (!e.isPlayer()) {
            return false;
        }
        Player player = BukkitAdapter.adapt(e.asPlayer());
        return this.checkInventory((Inventory)player.getInventory());
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        Location location = BukkitAdapter.adapt(l);
        BlockState blockState = location.getBlock().getState();
        if (!(blockState instanceof Container)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Location " + String.valueOf(location) + " is not a container, returning FALSE", new Object[0]);
            return false;
        }
        Container container = (Container)blockState;
        return this.checkInventory(container.getInventory());
    }

    private boolean checkInventory(Inventory inventory) {
        if (this.matcher == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Matcher is null, something went wrong on load", new Object[0]);
            return false;
        }
        int count = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !this.matcher.matches(BukkitAdapter.adapt(item))) continue;
            count += item.getAmount();
        }
        return this.amount.equals(count);
    }
}

