/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Optional;

@MythicCondition(author="Ashijin", name="holding", aliases={}, description="Checks if the target is holding a given material")
public class HoldingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="types", aliases={"types", "type", "t", "material", "mat", "m", "item", "i"}, description="A list of materials to check")
    private AbstractItemMatcher matcher;

    public HoldingCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.matcher = HoldingCondition.getPlugin().getBootstrap().getItemMatcher(mlc, this.conditionVar);
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (this.matcher == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Matcher is null, something went wrong on load", new Object[0]);
            return false;
        }
        if (!target.isLiving()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target is not living entity", new Object[0]);
            return false;
        }
        Optional<AbstractItemStack> maybeItem = target.getItemMainHand();
        if (maybeItem.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "No item in hand", new Object[0]);
            return false;
        }
        AbstractItemStack holding = maybeItem.get();
        return this.matcher.matches(holding);
    }
}

