/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.damage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.entity.EntityDamageEvent;

public abstract class DamagingMechanic
extends SkillMechanic {
    protected boolean triggerSkills;
    protected boolean ignoresArmor;
    protected boolean preventImmunity;
    protected boolean preventKnockback;
    protected boolean ignoresEnchantments;
    protected PlaceholderString element;
    protected EntityDamageEvent.DamageCause cause;
    protected boolean ignoreInvulnerability;
    protected boolean damagesHelmet;
    protected boolean noAnger;
    protected boolean ignoreEffects;
    protected boolean ignoreShield;
    protected boolean ignoreResistance;
    @MythicField(name="powerAffectsDamage", aliases={"pad"}, description="Whether the skill's power affects damage", defValue="true")
    protected boolean powerAffectsDamage;
    protected Collection<String> tags = Lists.newArrayList();
    protected Map<String, PlaceholderString> parameters = new ConcurrentHashMap<String, PlaceholderString>();

    @Deprecated
    public DamagingMechanic(SkillExecutor manager, String file, MythicLineConfig mlc) {
        this(manager, new File(file), mlc.getLine(), mlc);
    }

    public DamagingMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.triggerSkills = mlc.getBoolean(new String[]{"triggerskills", "ts"}, false);
        this.ignoresArmor = mlc.getBoolean(new String[]{"ignorearmor", "ia", "i"}, false);
        this.preventImmunity = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
        this.preventKnockback = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        this.ignoresEnchantments = mlc.getBoolean(new String[]{"ignoreenchantments", "ignoreenchants", "ie"}, false);
        this.element = mlc.getPlaceholderString(new String[]{"element", "e", "damagetype"}, null, new String[0]);
        this.noAnger = mlc.getBoolean(new String[]{"noanger", "na"}, false);
        this.ignoreInvulnerability = mlc.getBoolean(new String[]{"ignoreinvulnerability", "ignoreinvulnerable", "ii"}, false);
        this.ignoreShield = mlc.getBoolean(new String[]{"ignoreshield", "is"}, false);
        this.damagesHelmet = mlc.getBoolean(new String[]{"damageshelmet", "dh"}, false);
        this.ignoreEffects = mlc.getBoolean(new String[]{"ignoreeffects", "ieff"}, false);
        this.ignoreResistance = mlc.getBoolean(new String[]{"ignoreresistance", "ir"}, false);
        this.cause = EntityDamageEvent.DamageCause.valueOf((String)mlc.getString(new String[]{"damagecause", "dc", "cause"}, "ENTITY_ATTACK", new String[0]).toUpperCase());
        this.powerAffectsDamage = mlc.getBoolean(new String[]{"poweraffectsdamage", "pad"}, true);
        String tags = mlc.getString(new String[]{"tags", "tag"}, null, new String[0]);
        if (tags != null) {
            for (String tag : tags.split(",")) {
                this.tags.add(tag.toUpperCase());
            }
        }
        if ((tags = mlc.getString(new String[]{"rawtags", "rtag"}, null, new String[0])) != null) {
            Collections.addAll(this.tags, tags.split(","));
        }
        if (this.element != null && !MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage types require MythicMobs Premium to use.");
            this.element = null;
        }
        this.buildParameters(mlc);
    }

    protected void doDamage(SkillMetadata data, AbstractEntity target, double amount) {
        this.doDamage(data, target, amount, 1.0);
    }

    protected void doDamage(SkillMetadata data, AbstractEntity target, double amount, double multiplier) {
        SkillCaster caster = data.getCaster();
        String element = this.element == null ? null : this.element.get(caster);
        DamageMetadata meta = new DamageMetadata(caster, data.getCasterItem(), amount, Maps.newTreeMap(), Maps.newTreeMap(), element, multiplier, this.ignoresArmor, this.preventImmunity, this.preventKnockback, this.ignoresEnchantments, this.cause);
        meta.putBoolean("trigger_skills", this.triggerSkills);
        meta.putBoolean("ignore_invulnerability", this.ignoreInvulnerability);
        meta.putBoolean("damages_helmet", this.damagesHelmet);
        meta.putBoolean("no_anger", this.noAnger);
        meta.putBoolean("ignore_shield", this.ignoreShield);
        meta.putBoolean("no_impact", this.preventKnockback);
        meta.putBoolean("ignore_effects", this.ignoreEffects);
        meta.putBoolean("ignore_resistance", this.ignoreResistance);
        if (element != null) {
            meta.putTag(element);
        }
        this.tags.forEach(tag -> meta.putTag((String)tag));
        this.parameters.forEach((k, v) -> meta.putObject((String)k, v.get(data)));
        SkillAdapter.get().doDamage(meta, target);
    }

    protected void buildParameters(MythicLineConfig config) {
        block57: for (Map.Entry<String, String> entry : config.entrySet()) {
            switch (entry.getKey().toLowerCase()) {
                case "triggerskills": 
                case "ts": 
                case "ignorearmor": 
                case "ia": 
                case "i": 
                case "preventimmunity": 
                case "pi": 
                case "preventknockback": 
                case "pkb": 
                case "pk": 
                case "ignoreenchantments": 
                case "ignoreenchants": 
                case "ie": 
                case "element": 
                case "e": 
                case "damagetype": 
                case "type": 
                case "damagecause": 
                case "dc": 
                case "cause": 
                case "cooldown": 
                case "cd": 
                case "delay": 
                case "repeat": 
                case "targetinterval": 
                case "targeti": 
                case "repeatinterval": 
                case "repeati": 
                case "power": 
                case "powersplitbetweentargets": 
                case "powersplit": 
                case "splitpower": 
                case "forcesync": 
                case "sync": 
                case "targetisorigin": 
                case "sourceisorigin": 
                case "castfromorigin": 
                case "fromorigin": 
                case "fo": 
                case "origin": 
                case "targetcreative": 
                case "noanger": 
                case "na": 
                case "ignoreinvulnerability": 
                case "ignoreinvulnerable": 
                case "ii": 
                case "damageshelmet": 
                case "dh": 
                case "ignoreeffects": 
                case "ieff": 
                case "ignoreresistance": 
                case "ir": {
                    continue block57;
                }
            }
            this.parameters.put(entry.getKey(), PlaceholderString.of(entry.getValue()));
        }
    }
}

