/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ChainMechanic;
import io.lumine.mythic.core.skills.mechanics.MissileMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

@MythicMechanic(author="Ashijin", name="chainmissile", aliases={"cmi"}, description="Shoots a chaining homing missile at the target")
public class ChainMissileMechanic
extends MissileMechanic
implements ITargetedEntitySkill {
    @MythicField(name="bounces", aliases={"b"}, defValue="2", version="4.12", description="How many times the chain should bounce")
    protected PlaceholderInt bounces;
    @MythicField(name="radius", aliases={"r"}, defValue="5", version="4.12", description="How far the skill will bounce to a new target")
    protected PlaceholderDouble bounceRadius;
    @MythicField(name="returnToCaster", aliases={"return", "rtc"}, defValue="false", version="4.12", description="If the missile should return to the caster")
    protected boolean returnToCaster;
    protected ChainMechanic.BounceSelector bounceSelector;
    protected String bounceConditionString;
    @MythicField(name="bounceConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.8", description="Conditions applied to the bounce target")
    protected List<SkillCondition> bounceConditions = null;

    public ChainMissileMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "ChainMissile mechanic requires Mythic Premium");
            return;
        }
        this.bounces = mlc.getPlaceholderInteger(new String[]{"bounces", "b"}, 2, new String[0]);
        this.bounceRadius = mlc.getPlaceholderDouble(new String[]{"bounceradius", "bouncerange", "radius", "range", "r"}, 5.0, new String[0]);
        this.returnToCaster = mlc.getBoolean(new String[]{"returntocaster", "return", "rtc"}, false);
        if (this.returnToCaster) {
            this.hitSelf = true;
        }
        this.bounceConditionString = mlc.getString(new String[]{"bounceconditions", "conditions", "cond", "c"}, null, new String[0]);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.bounceConditionString != null) {
                this.bounceConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.bounceConditionString);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "ChainMissile mechanic requires Mythic Premium");
            return SkillResult.REQUIRES_PREMIUM;
        }
        try {
            new ChainMissileTracker(data, target).start();
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    public class ChainMissileTracker
    extends MissileMechanic.MissileTracker {
        AbstractEntity currentBounce;
        UUID currentBounceUUID;
        AbstractLocation currentOrigin;
        protected final double bounceRadius;
        protected final double bounceRadiusSq;
        protected int bouncesRemaining;
        protected float power;
        protected boolean finalBounce;
        protected ObjectOpenHashSet<AbstractEntity> alreadyHit;

        public ChainMissileTracker(SkillMetadata data, AbstractEntity target) {
            super((MissileMechanic)ChainMissileMechanic.this, data, target);
            this.finalBounce = false;
            this.alreadyHit = new ObjectOpenHashSet();
            this.currentBounce = data.getCaster().getEntity();
            this.currentBounceUUID = this.currentBounce.getUniqueId();
            this.currentOrigin = data.getCaster().getLocation();
            this.bouncesRemaining = ChainMissileMechanic.this.bounces.get(data);
            this.bounceRadius = ChainMissileMechanic.this.bounceRadius.get(data);
            this.bounceRadiusSq = Math.pow(this.bounceRadius, 2.0);
            this.evaluatePotentialTargets();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ ChainMissile fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), ChainMissileMechanic.this.line);
        }

        @Override
        public AbstractLocation getTarget() {
            if (this.target != null) {
                if (this.target.isDead() || !this.target.isValid()) {
                    this.doBounce(this.target);
                }
                return this.target.getLocation();
            }
            return this.targetLocation.clone();
        }

        @Override
        public void doHit(Collection<AbstractEntity> targets) {
            if (!ChainMissileMechanic.this.onHitSkill.isPresent()) {
                return;
            }
            this.data = this.data.deepClone();
            this.data.setEntityTargets(targets);
            this.data.setOrigin(this.currentLocation.clone());
            AbstractEntity hit = null;
            Iterator<AbstractEntity> iterator = targets.iterator();
            if (iterator.hasNext()) {
                AbstractEntity t2;
                hit = t2 = iterator.next();
            }
            if (hit == null) {
                return;
            }
            this.alreadyHit.add((Object)hit);
            if (((Skill)ChainMissileMechanic.this.onHitSkill.get()).isUsable(this.data)) {
                VariableRegistry vars = this.data.getVariables();
                vars.putInt("chain-bounces", this.bouncesRemaining);
                ((Skill)ChainMissileMechanic.this.onHitSkill.get()).execute(this.data);
            }
            if (hit.equals(this.target)) {
                if (this.finalBounce) {
                    this.terminate();
                } else {
                    this.doBounce(hit);
                }
            }
        }

        private void doBounce(AbstractEntity hit) {
            this.currentBounce = hit;
            this.currentBounceUUID = hit.getUniqueId();
            --this.bouncesRemaining;
            if (this.bouncesRemaining == 0) {
                if (ChainMissileMechanic.this.returnToCaster && !this.target.equals(this.data.getCaster().getEntity())) {
                    this.target = this.data.getCaster().getEntity();
                    this.finalBounce = true;
                } else {
                    this.terminate();
                }
            } else if (this.bouncesRemaining < 0) {
                this.terminate();
            } else {
                this.target = this.getNextTarget();
            }
        }

        private void evaluatePotentialTargets() {
            double maxDistance = Math.pow(this.bounceRadius * (double)this.bouncesRemaining * 2.0, 2.0);
            if (ChainMissileMechanic.this.hitSelf || ChainMissileMechanic.this.hitPlayers || ChainMissileMechanic.this.hitNonPlayers) {
                this.inRange.addAll(this.data.getCaster().getLocation().getWorld().getLivingEntities());
                this.inRange.removeIf(e -> {
                    if (e == null) {
                        return true;
                    }
                    if (this.bullet != null && this.bullet.equals(e)) {
                        return true;
                    }
                    if (this.currentOrigin.distanceSquared(e.getLocation()) > maxDistance && !e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!ChainMissileMechanic.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!ChainMissileMechanic.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    return !ChainMissileMechanic.this.hitNonPlayers && !e.isPlayer();
                });
                if (ChainMissileMechanic.this.returnToCaster) {
                    this.inRange.add((Object)this.data.getCaster().getEntity());
                }
            }
        }

        private AbstractEntity getNextTarget() {
            if (this.currentBounce == null) {
                return null;
            }
            AbstractEntity target = null;
            double range = 0.0;
            for (AbstractEntity entity : this.inRange) {
                AbstractLocation origin;
                double nextRange;
                if (entity == null || entity.isDead() || !entity.isValid() || this.alreadyHit.contains((Object)entity) || ChainMissileMechanic.this.returnToCaster && entity.equals(this.data.getCaster().getEntity()) || (nextRange = (origin = this.currentBounce != null ? this.currentBounce.getLocation() : this.currentOrigin).distanceSquared(entity.getLocation())) > this.bounceRadiusSq) continue;
                if (ChainMissileMechanic.this.bounceConditions != null) {
                    boolean ok = true;
                    for (SkillCondition condition : ChainMissileMechanic.this.bounceConditions) {
                        if (condition.evaluateToEntity(this.currentBounce, entity)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                }
                if (target == null) {
                    target = entity;
                    range = this.currentBounce.getLocation().distanceSquared(entity.getLocation());
                    continue;
                }
                if (!(nextRange < range)) continue;
                target = entity;
                range = nextRange;
            }
            if (target == null) {
                if (ChainMissileMechanic.this.returnToCaster) {
                    target = this.data.getCaster().getEntity();
                    this.finalBounce = true;
                } else {
                    this.terminate();
                    return null;
                }
            }
            return target;
        }

        public AbstractEntity getCurrentBounce() {
            return this.currentBounce;
        }

        public UUID getCurrentBounceUUID() {
            return this.currentBounceUUID;
        }

        public AbstractLocation getCurrentOrigin() {
            return this.currentOrigin;
        }

        public double getBounceRadius() {
            return this.bounceRadius;
        }

        public double getBounceRadiusSq() {
            return this.bounceRadiusSq;
        }

        public int getBouncesRemaining() {
            return this.bouncesRemaining;
        }

        public float getPower() {
            return this.power;
        }
    }
}

