/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileSurfaceMode;
import io.lumine.mythic.core.utils.BlockUtil;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicFields;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.physics.CollisionHelper;
import io.lumine.mythic.core.utils.physics.PhysicsCollision;
import java.io.File;
import java.util.Collection;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;

@MythicMechanic(author="Ashijin", name="missile", aliases={"mi"}, description="Shoots a homing missile at the target")
public class MissileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="inertia", aliases={"intertia", "in"}, description="The inertia of the projectile", defValue="1.5")
    protected PlaceholderFloat projectileInertia;
    @MythicFields(value={@MythicField(name="hugSurface", aliases={"hs"}, description="Whether the projectile will hug the surface", defValue="false"), @MythicField(name="hugLiquid", aliases={"hugWater", "hugLava"}, description="If hugSurface is set, determines whether the projectile will hug liquid", defValue="false")})
    protected ProjectileSurfaceMode surfaceMode = ProjectileSurfaceMode.NONE;
    @MythicField(name="heightFromSurface", aliases={"hfs"}, description="    The offset depends on the type of the projectile and if hugSurface is set.\n    NORMAL - how high above the surface the projectile will glide.\n    METEOR - how high above the surface the projectile starts above the target\n", defValue="0.5")
    protected float heightFromSurface;
    @MythicField(name="maxClimbHeight", aliases={"mch"}, description="The number of attempts the projectile will try to increase its y-location before terminating the projectile", defValue="3")
    protected float maxClimbHeight;
    @MythicField(name="maxDropHeight", aliases={"mdh"}, description="The number of attempts the projectile will try to decrease its y-location before terminating the projectile", defValue="10")
    protected float maxDropHeight;
    @MythicField(name="bounces", aliases={"bounce"}, description="The projectile can bounce", defValue="false", premium=true)
    protected boolean bounce;
    @MythicField(name="bounceVelocity", aliases={"bv"}, description="The velocity modifier of the bounce", defValue="0.9")
    protected float bounceVelocityMod;
    @MythicField(name="highaccuracymode", aliases={"ham"}, description="Whether to use high-accuracy mode, which raytraces every tick to ensure the projectile cannot ever go anything", defValue="PLAYERS_ONLY")
    protected Projectile.ProjectileTriOption highAccuracyMode;

    public MissileMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, true);
        this.projectileInertia = mlc.getPlaceholderFloat(new String[]{"intertia", "inertia", "in"}, 1.5f, new String[0]);
        this.bounce = mlc.getBoolean(new String[]{"bounces", "bounce"}, false);
        this.bounceVelocityMod = mlc.getFloat(new String[]{"bouncevelocity", "bv"}, 0.9f);
        boolean hugSurface = mlc.getBoolean(new String[]{"hugsurface", "hs"}, false);
        this.heightFromSurface = mlc.getFloat(new String[]{"heightfromsurface", "hfs"}, 0.5f);
        this.maxClimbHeight = mlc.getFloat(new String[]{"maxclimbheight", "mch"}, 3.0f);
        this.maxDropHeight = mlc.getFloat(new String[]{"maxdropheight", "mdh"}, 10.0f);
        String highAccuracyDefault = "PLAYERS_ONLY";
        if (hugSurface) {
            highAccuracyDefault = "FALSE";
            boolean hugWater = mlc.getBoolean(new String[]{"hugliquid", "hugwater", "huglava"}, false);
            this.surfaceMode = hugWater ? ProjectileSurfaceMode.WATER : ProjectileSurfaceMode.SURFACE;
        }
        String highAccuracyMode = mlc.getString(new String[]{"highaccuracymode", "ham"}, highAccuracyDefault, new String[0]);
        try {
            this.highAccuracyMode = Projectile.ProjectileTriOption.valueOf(highAccuracyMode.toUpperCase());
        }
        catch (Throwable ex) {
            MythicLogger.errorMechanic(this, "Invalid input for highAccuracyMode option '" + highAccuracyMode + "'");
            this.highAccuracyMode = Projectile.ProjectileTriOption.PLAYERS_ONLY;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new MissileTracker(data, target).start();
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new MissileTracker(data, target).start();
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    public ProjectileSurfaceMode getSurfaceMode() {
        return this.surfaceMode;
    }

    public class MissileTracker
    extends Projectile.ProjectileTracker {
        protected float inertia;
        protected AbstractEntity target;
        protected AbstractLocation targetLocation;
        protected double targetYOffset;

        public MissileTracker(SkillMetadata data, AbstractEntity target) {
            super(MissileMechanic.this, data, target.getLocation());
            this.target = null;
            this.targetLocation = null;
            this.target = target;
            this.targetLocation = target.getLocation();
            this.inertia = MissileMechanic.this.projectileInertia.get(data, target);
            this.velocityMagnitude = MissileMechanic.this.projectileVelocity.get(data) / MissileMechanic.this.ticksPerSecond;
            if (MissileMechanic.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(MissileMechanic.this.tickInterpolation + 1);
            }
        }

        public MissileTracker(SkillMetadata data, AbstractLocation target) {
            super(MissileMechanic.this, data, target);
            this.target = null;
            this.targetLocation = null;
            this.target = null;
            this.targetLocation = target;
            this.inertia = MissileMechanic.this.projectileInertia.get(data);
            this.velocityMagnitude = MissileMechanic.this.projectileVelocity.get(data) / MissileMechanic.this.ticksPerSecond;
            if (MissileMechanic.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(MissileMechanic.this.tickInterpolation + 1);
            }
        }

        public AbstractLocation getTarget() {
            if (this.target != null) {
                return this.target.getLocation();
            }
            return this.targetLocation.clone();
        }

        @Override
        public void projectileStart() {
            double sso;
            this.velocityMagnitude = MissileMechanic.this.projectileVelocity.get(this.data) / MissileMechanic.this.ticksPerSecond;
            if (MissileMechanic.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(MissileMechanic.this.tickInterpolation + 1);
            }
            this.startLocation = MissileMechanic.this.fromOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
            double tyo = MissileMechanic.this.getTargetYOffset().get(this.data);
            this.targetYOffset = this.target != null ? (tyo == 0.0 ? this.target.getEyeLocation().getY() - this.target.getLocation().getY() : tyo) : tyo;
            double syo = MissileMechanic.this.startYOffset.get(this.data);
            if (syo != 0.0) {
                this.startLocation.setY(this.startLocation.getY() + syo);
            }
            if (MissileMechanic.this.startForwardOffset.get(this.data) * -1.0f != 0.0f) {
                this.startLocation = MythicUtil.move(MissileMechanic.this.faulty, this.startLocation, MissileMechanic.this.startForwardOffset.get(this.data) * -1.0f, 0.0, 0.0);
            }
            if ((sso = MissileMechanic.this.startSideOffset.get(this.data)) != 0.0) {
                this.startLocation = MythicUtil.move(MissileMechanic.this.faulty, this.startLocation, 0.0, 0.0, sso);
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            if (MissileMechanic.this.projectileStartDirection.isPresent()) {
                AbstractLocation startVectorTarget = ((MythicBukkit)MissileMechanic.this.getPlugin()).getSkillManager().getLocationTarget((SkillTargeter)MissileMechanic.this.projectileStartDirection.get(), this.data);
                this.currentVelocity = startVectorTarget.toVector().rotate(0.001f).subtract(this.currentLocation.toVector()).normalize();
            } else {
                this.currentVelocity = this.getTarget().toVector().rotate(0.001f).subtract(this.currentLocation.toVector()).normalize();
            }
            this.currentLocation.setDirection(this.currentVelocity);
            if (MissileMechanic.this.projectileVelocityHorizOffset.get(this.data) != 0.0f || MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                float noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityHorizNoise);
                }
                this.currentVelocity.rotate(MissileMechanic.this.projectileVelocityHorizOffset.get(this.data) + noise);
            }
            if (MissileMechanic.this.projectileVelocityVertOffset.get(this.data) != 0.0f || MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                float noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityVertNoise);
                }
                this.currentVelocity.add(new AbstractVector(0.0f, MissileMechanic.this.projectileVelocityVertOffset.get(this.data) + noise, 0.0f)).normalize();
            }
            if (MissileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                this.currentLocation.setY((float)((int)this.currentLocation.getY()) + MissileMechanic.this.heightFromSurface);
                this.currentVelocity.setY(0).normalize();
            }
            if (MissileMechanic.this.powerAffectsVelocity) {
                this.velocityMagnitude *= (double)this.power;
            }
            this.currentVelocity.multiply(this.velocityMagnitude);
            if (MissileMechanic.this.bullet != null) {
                this.bullet = MissileMechanic.this.bullet.create(this, this.target);
            }
        }

        private boolean isHighAccuracy() {
            return MissileMechanic.this.highAccuracyMode == Projectile.ProjectileTriOption.TRUE || MissileMechanic.this.highAccuracyMode == Projectile.ProjectileTriOption.PLAYERS_ONLY && this.data.getCaster().getEntity().isPlayer();
        }

        @Override
        public void projectileMove() {
            RayTraceResult traceResult;
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            this.currentVelocity.multiply(this.inertia);
            this.currentVelocity.add(this.getTarget().add(0.0, this.targetYOffset, 0.0).subtract(this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ()).toVector().normalize());
            if (MissileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                this.currentVelocity.setY(0);
            }
            this.currentVelocity.normalize().multiply(this.velocityMagnitude);
            if (this.isHighAccuracy() && (traceResult = ((MythicBukkit)MissileMechanic.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().rayTraceBlock(this.previousLocation, this.currentLocation, FluidCollisionMode.NEVER, true)) != null && traceResult.getHitBlock() != null && !traceResult.getHitBlock().isEmpty()) {
                AbstractLocation hitLocation = BukkitAdapter.adapt(traceResult.getHitPosition()).toLocation(this.currentLocation.getWorld());
                Location from = BukkitAdapter.adapt(this.previousLocation);
                Location to = BukkitAdapter.adapt(hitLocation);
                if (this.previousLocation.distanceSquared(hitLocation) <= this.previousLocation.distanceSquared(this.currentLocation)) {
                    if (MissileMechanic.this.stopOnHitGround) {
                        this.currentLocation = hitLocation;
                    } else if (MissileMechanic.this.onHitBlockSkill.isPresent() && ((Skill)MissileMechanic.this.onHitBlockSkill.get()).isUsable(this.data)) {
                        SkillMetadata sData = this.data.deepClone();
                        AbstractLocation location = MissileMechanic.this.bulletType.isPresent() && MissileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                        ((Skill)MissileMechanic.this.onHitBlockSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
                    }
                }
            }
            if (MissileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE && (this.currentLocation.getBlockX() != this.previousLocation.getBlockX() || this.currentLocation.getBlockZ() != this.previousLocation.getBlockZ())) {
                Block b = BukkitAdapter.adapt(this.currentLocation).subtract(0.0, (double)MissileMechanic.this.heightFromSurface, 0.0).getBlock();
                if (BlockUtil.isPathable(b, MissileMechanic.this.surfaceMode)) {
                    boolean ok;
                    block21: {
                        attempts = 0;
                        ok = false;
                        while (true) {
                            int n = attempts++;
                            if (!((float)n < MissileMechanic.this.maxDropHeight)) break block21;
                            if (!BlockUtil.isPathable(b = b.getRelative(BlockFace.DOWN), MissileMechanic.this.surfaceMode)) break;
                            this.currentLocation.subtract(0.0, 1.0, 0.0);
                        }
                        ok = true;
                    }
                    if (!ok) {
                        this.terminate();
                        return;
                    }
                } else {
                    boolean ok;
                    block22: {
                        attempts = 0;
                        ok = false;
                        do {
                            int n = attempts++;
                            if (!((float)n < MissileMechanic.this.maxClimbHeight)) break block22;
                            b = b.getRelative(BlockFace.UP);
                            this.currentLocation.add(0.0, 1.0, 0.0);
                        } while (!BlockUtil.isPathable(b));
                        ok = true;
                    }
                    if (!ok) {
                        this.terminate();
                        return;
                    }
                }
                this.currentLocation.setY((float)((int)this.currentLocation.getY()) + MissileMechanic.this.heightFromSurface);
            }
            if (MissileMechanic.this.bounce && MythicBukkit.isVolatile()) {
                try {
                    if (this.handleBounce()) {
                        this.executeProjectileSkill(MissileMechanic.this.onBounceSkill, this.data, false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.errorMechanicConfig(MissileMechanic.this, MissileMechanic.this.config, "An error occurred while calculating projectile bounce (did you set the bounding box to zero?)");
                    ex.printStackTrace();
                }
            } else if (MissileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                if (MissileMechanic.this.onHitBlockSkill.isPresent() && ((Skill)MissileMechanic.this.onHitBlockSkill.get()).isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    AbstractLocation location = MissileMechanic.this.bulletType.isPresent() && MissileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                    ((Skill)MissileMechanic.this.onHitBlockSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
                }
                this.terminate();
                return;
            }
            if (this.target != null && (this.target.isDead() || !this.target.isValid())) {
                this.terminate();
                return;
            }
        }

        @Override
        public void projectileTick() {
            if (MissileMechanic.this.onTickSkill.isPresent() && ((Skill)MissileMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = MissileMechanic.this.bulletType.isPresent() && MissileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                ((Skill)MissileMechanic.this.onTickSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
            }
            this.evaluateTargetsInBB();
            if (this.targets.size() > 0) {
                this.doHit((Collection<AbstractEntity>)this.targets.clone());
            }
            this.targets.clear();
        }

        public void setVelocity(double value) {
            this.velocityMagnitude = value / (double)MissileMechanic.this.ticksPerSecond;
            if (MissileMechanic.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(MissileMechanic.this.tickInterpolation + 1);
            }
        }

        public void multiplyVelocity(double v) {
            this.velocityMagnitude *= v;
        }

        public void addVelocity(double v) {
            if (MissileMechanic.this.tickInterpolation > 0) {
                v /= (double)(MissileMechanic.this.tickInterpolation + 1);
            }
            this.velocityMagnitude = (this.velocityMagnitude * (double)MissileMechanic.this.ticksPerSecond + v) / (double)MissileMechanic.this.ticksPerSecond;
        }

        public void setInertia(float p) {
            this.inertia = p;
        }

        public void multiplyInertia(float p) {
            this.inertia *= p;
        }

        public void addInertia(float p) {
            this.inertia += p;
        }

        public void doHit(Collection<AbstractEntity> targets) {
            if (MissileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)MissileMechanic.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)MissileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
            for (AbstractEntity target : targets) {
                if (!MissileMechanic.this.canStopAtEntity(this.data, target)) continue;
                this.terminate();
                break;
            }
        }

        public boolean handleBounce() {
            BoundingBox bb = BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)MissileMechanic.this.hitRadius.get(this.data), (double)MissileMechanic.this.verticalHitRadius.get(this.data), (double)MissileMechanic.this.hitRadius.get(this.data));
            BlockFace collided = null;
            double bV = 0.0;
            for (PhysicsCollision collision : CollisionHelper.getCollisions(this.currentVelocity, bb, this.previousLocation)) {
                switch (collision.getBlockFace()) {
                    case NORTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.NORTH;
                        break;
                    }
                    case EAST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.EAST;
                        break;
                    }
                    case SOUTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.SOUTH;
                        break;
                    }
                    case WEST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.WEST;
                        break;
                    }
                    case UP: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.UP;
                        break;
                    }
                    case DOWN: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.DOWN;
                        break;
                    }
                }
            }
            if (collided == null) {
                return false;
            }
            switch (collided) {
                case NORTH: {
                    if (!(this.currentVelocity.getZ() > 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case EAST: {
                    if (!(this.currentVelocity.getX() < 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case SOUTH: {
                    if (!(this.currentVelocity.getZ() < 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case WEST: {
                    if (!(this.currentVelocity.getX() > 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case UP: {
                    if (!(this.currentVelocity.getY() < 0.0)) break;
                    this.currentVelocity.setY(this.currentVelocity.getY() * -0.995);
                    break;
                }
                case DOWN: {
                    if (!(this.currentVelocity.getY() > 0.0)) break;
                    this.currentVelocity.setY(this.currentVelocity.getY() * -0.995);
                }
            }
            this.currentVelocity.multiply(MissileMechanic.this.bounceVelocityMod);
            return true;
        }
    }
}

