/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.mechanics.MissileMechanic;
import io.lumine.mythic.core.skills.mechanics.OrbitalMechanic;
import io.lumine.mythic.core.skills.mechanics.ProjectileMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="modifyprojectile", description="Modifies an attribute of the projectile that executed the mechanic")
public class ModifyProjectileMechanic
extends SkillMechanic
implements INoTargetSkill {
    @MythicField(name="trait", aliases={"t"}, defValue="VELOCITY", description="The trait of the projectile to modify.")
    private ProjectileTrait trait;
    @MythicField(name="action", aliases={"a"}, defValue="MULTIPLY", description="The action to perform for modifying the projectile trait.")
    private ModifyAction action;
    @MythicField(name="value", aliases={"v"}, defValue="0", description="The value to use for the modification.")
    private final PlaceholderDouble value;

    public ModifyProjectileMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        String t2 = mlc.getString(new String[]{"trait", "t"}, "VELOCITY", new String[0]);
        try {
            this.trait = ProjectileTrait.valueOf(t2.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String a = mlc.getString(new String[]{"action", "a"}, "MULTIPLY", new String[0]);
        try {
            this.action = ModifyAction.valueOf(a.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.value = mlc.getPlaceholderDouble(new String[]{"value", "v"}, 0.0, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        IParentSkill iParentSkill = data.getCallingEvent();
        if (iParentSkill instanceof ProjectileMechanic.ProjectileMechanicTracker) {
            ProjectileMechanic.ProjectileMechanicTracker projectileTracker = (ProjectileMechanic.ProjectileMechanicTracker)iParentSkill;
            this.apply(projectileTracker, this.action, this.trait, (float)this.value.get(data));
        } else {
            iParentSkill = data.getCallingEvent();
            if (iParentSkill instanceof MissileMechanic.MissileTracker) {
                MissileMechanic.MissileTracker missileTracker = (MissileMechanic.MissileTracker)iParentSkill;
                this.apply(missileTracker, this.action, this.trait, this.value.get(data));
            } else {
                iParentSkill = data.getCallingEvent();
                if (iParentSkill instanceof OrbitalMechanic.OrbitalTracker) {
                    OrbitalMechanic.OrbitalTracker orbitalTracker = (OrbitalMechanic.OrbitalTracker)iParentSkill;
                    this.apply(orbitalTracker, this.action, this.trait, this.value.get(data));
                }
            }
        }
        return SkillResult.SUCCESS;
    }

    void apply(ProjectileMechanic.ProjectileMechanicTracker projectile, ModifyAction action, ProjectileTrait trait, float value) {
        block0 : switch (action.ordinal()) {
            case 0: {
                switch (trait.ordinal()) {
                    case 3: {
                        projectile.multiplyVelocity(value);
                        break;
                    }
                    case 2: {
                        projectile.multiplyPower(value);
                        break;
                    }
                    case 1: {
                        projectile.multiplyGravity(value);
                    }
                }
                break;
            }
            case 1: {
                switch (trait.ordinal()) {
                    case 3: {
                        projectile.addVelocity(value);
                        break;
                    }
                    case 2: {
                        projectile.addPower(value);
                        break;
                    }
                    case 1: {
                        projectile.addGravity(value);
                    }
                }
                break;
            }
            case 2: {
                switch (trait.ordinal()) {
                    case 3: {
                        projectile.setVelocity(value);
                        break block0;
                    }
                    case 2: {
                        projectile.setPower(value);
                        break block0;
                    }
                    case 1: {
                        projectile.setGravity(value);
                    }
                }
            }
        }
    }

    void apply(MissileMechanic.MissileTracker missile, ModifyAction action, ProjectileTrait trait, double value) {
        block0 : switch (action.ordinal()) {
            case 0: {
                switch (trait.ordinal()) {
                    case 3: {
                        missile.multiplyVelocity(value);
                        break;
                    }
                    case 2: {
                        missile.multiplyPower((float)value);
                        break;
                    }
                    case 0: {
                        missile.multiplyInertia((float)value);
                    }
                }
                break;
            }
            case 1: {
                switch (trait.ordinal()) {
                    case 3: {
                        missile.addVelocity(value);
                        break;
                    }
                    case 2: {
                        missile.addPower((float)value);
                        break;
                    }
                    case 0: {
                        missile.addInertia((float)value);
                    }
                }
                break;
            }
            case 2: {
                switch (trait.ordinal()) {
                    case 3: {
                        missile.setVelocity(value);
                        break block0;
                    }
                    case 2: {
                        missile.setPower((float)value);
                        break block0;
                    }
                    case 0: {
                        missile.setInertia((float)value);
                    }
                }
            }
        }
    }

    void apply(OrbitalMechanic.OrbitalTracker orbital, ModifyAction action, ProjectileTrait trait, double value) {
        block0 : switch (action.ordinal()) {
            case 0: {
                switch (trait.ordinal()) {
                    case 4: {
                        orbital.multiplyRadius((float)value);
                        break;
                    }
                    case 5: {
                        orbital.multiplyYOffset((float)value);
                    }
                }
                break;
            }
            case 1: {
                switch (trait.ordinal()) {
                    case 4: {
                        orbital.addRadius((float)value);
                        break;
                    }
                    case 5: {
                        orbital.addYOffset((float)value);
                    }
                }
                break;
            }
            case 2: {
                switch (trait.ordinal()) {
                    case 4: {
                        orbital.setRadius((float)value);
                        break block0;
                    }
                    case 5: {
                        orbital.setYOffset((float)value);
                    }
                }
            }
        }
    }

    private static enum ProjectileTrait {
        INERTIA,
        GRAVITY,
        POWER,
        VELOCITY,
        RADIUS,
        YOFFSET;

    }

    private static enum ModifyAction {
        MULTIPLY,
        ADD,
        SET;

    }
}

