/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="effect:particleEquation", aliases={"e:peq", "peq", "particleEquation"})
public class ParticleEquationEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String equationStr;
    protected double precision;
    protected double tolerance;
    protected Map<String, Double> variables;
    protected Expression expression;

    public ParticleEquationEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.equationStr = mlc.getString("equation", "x^2 + y^2 + z^2");
        this.precision = mlc.getDouble("precision", 1.0);
        this.tolerance = mlc.getDouble("tolerance", 0.1);
        String variablesStr = mlc.getString("variables", "");
        this.variables = new HashMap<String, Double>();
        if (!variablesStr.isEmpty()) {
            String[] vars = variablesStr.split(";");
            for (String var : vars) {
                String[] kv = var.split("=");
                if (kv.length != 2) continue;
                String key = kv[0];
                double value = Double.parseDouble(kv[1]);
                this.variables.put(key, value);
            }
        }
        ExpressionBuilder builder = new ExpressionBuilder(this.equationStr).variables("x", "y", "z");
        for (String varName : this.variables.keySet()) {
            builder.variable(varName);
        }
        this.expression = builder.build();
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleEquationEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleEquationEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleEquationEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone();
        AbstractLocation startLocation = this.fromOrigin ? origin : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation());
        double minX = Math.min(startLocation.getX(), targetLocation.getX());
        double minY = Math.min(startLocation.getY(), targetLocation.getY());
        double minZ = Math.min(startLocation.getZ(), targetLocation.getZ());
        double maxX = Math.max(startLocation.getX(), targetLocation.getX());
        double maxY = Math.max(startLocation.getY(), targetLocation.getY());
        double maxZ = Math.max(startLocation.getZ(), targetLocation.getZ());
        for (double x = minX; x <= maxX; x += this.precision) {
            for (double y = minY; y <= maxY; y += this.precision) {
                for (double z = minZ; z <= maxZ; z += this.precision) {
                    this.expression.setVariable("x", x);
                    this.expression.setVariable("y", y);
                    this.expression.setVariable("z", z);
                    for (Map.Entry<String, Double> entry : this.variables.entrySet()) {
                        this.expression.setVariable(entry.getKey(), entry.getValue());
                    }
                    double result = this.expression.evaluate();
                    if (!(Math.abs(result) <= this.tolerance)) continue;
                    AbstractLocation particleLocation = startLocation.clone();
                    particleLocation.setX(x);
                    particleLocation.setY(y);
                    particleLocation.setZ(z);
                    this.playParticleEffect(data, particleLocation, audience);
                }
            }
        }
    }
}

